/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.ClipData;
import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.view.ContentInfoCompat;
import androidx.core.view.OnReceiveContentListener;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class TextViewOnReceiveContentListener
implements OnReceiveContentListener {
    private static final String LOG_TAG = "ReceiveContent";

    @Override
    @Nullable
    public ContentInfoCompat onReceiveContent(@NonNull View view, @NonNull ContentInfoCompat payload) {
        int source;
        if (Log.isLoggable((String)LOG_TAG, (int)3)) {
            Log.d((String)LOG_TAG, (String)("onReceive: " + payload));
        }
        if ((source = payload.getSource()) == 2) {
            return payload;
        }
        ClipData clip = payload.getClip();
        int flags = payload.getFlags();
        TextView textView = (TextView)view;
        Editable editable = (Editable)textView.getText();
        Context context = textView.getContext();
        boolean didFirst = false;
        for (int i = 0; i < clip.getItemCount(); ++i) {
            CharSequence itemText = TextViewOnReceiveContentListener.coerceToText(context, clip.getItemAt(i), flags);
            if (itemText == null) continue;
            if (!didFirst) {
                TextViewOnReceiveContentListener.replaceSelection(editable, itemText);
                didFirst = true;
                continue;
            }
            editable.insert(Selection.getSelectionEnd((CharSequence)editable), (CharSequence)"\n");
            editable.insert(Selection.getSelectionEnd((CharSequence)editable), itemText);
        }
        return null;
    }

    private static CharSequence coerceToText(@NonNull Context context, @NonNull ClipData.Item item, int flags) {
        if (Build.VERSION.SDK_INT >= 16) {
            return Api16Impl.coerce(context, item, flags);
        }
        return ApiImpl.coerce(context, item, flags);
    }

    private static void replaceSelection(@NonNull Editable editable, @NonNull CharSequence replacement) {
        int selStart = Selection.getSelectionStart((CharSequence)editable);
        int selEnd = Selection.getSelectionEnd((CharSequence)editable);
        int start = Math.max(0, Math.min(selStart, selEnd));
        int end = Math.max(0, Math.max(selStart, selEnd));
        Selection.setSelection((Spannable)editable, (int)end);
        editable.replace(start, end, replacement);
    }

    @RequiresApi(value=16)
    private static final class Api16Impl {
        private Api16Impl() {
        }

        static CharSequence coerce(@NonNull Context context, @NonNull ClipData.Item item, int flags) {
            if ((flags & 1) != 0) {
                CharSequence text = item.coerceToText(context);
                return text instanceof Spanned ? text.toString() : text;
            }
            return item.coerceToStyledText(context);
        }
    }

    private static final class ApiImpl {
        private ApiImpl() {
        }

        static CharSequence coerce(@NonNull Context context, @NonNull ClipData.Item item, int flags) {
            CharSequence text = item.coerceToText(context);
            if ((flags & 1) != 0 && text instanceof Spanned) {
                text = text.toString();
            }
            return text;
        }
    }
}

