/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import android.webkit.CookieManager;
import androidx.annotation.NonNull;
import androidx.webkit.internal.ApiFeature;
import androidx.webkit.internal.CookieManagerAdapter;
import androidx.webkit.internal.WebViewFeatureInternal;
import androidx.webkit.internal.WebViewGlueCommunicator;
import java.util.List;

public class CookieManagerCompat {
    private CookieManagerCompat() {
    }

    @NonNull
    public static List<String> getCookieInfo(@NonNull CookieManager cookieManager, @NonNull String url) {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.GET_COOKIE_INFO;
        if (feature.isSupportedByWebView()) {
            return CookieManagerCompat.getAdapter(cookieManager).getCookieInfo(url);
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    private static CookieManagerAdapter getAdapter(CookieManager cookieManager) {
        return WebViewGlueCommunicator.getCompatConverter().convertCookieManager(cookieManager);
    }
}

