/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.webkit.internal.ApiHelperForP;
import androidx.webkit.internal.StartupApiFeature;
import androidx.webkit.internal.WebViewFeatureInternal;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ProcessGlobalConfig {
    private static final AtomicReference<HashMap<String, Object>> sProcessGlobalConfig = new AtomicReference();
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static boolean sApplyCalled = false;
    String mDataDirectorySuffix;
    String mDataDirectoryBasePath;
    String mCacheDirectoryBasePath;

    @NonNull
    public ProcessGlobalConfig setDataDirectorySuffix(@NonNull Context context, @NonNull String suffix) {
        StartupApiFeature.P feature = WebViewFeatureInternal.STARTUP_FEATURE_SET_DATA_DIRECTORY_SUFFIX;
        if (!feature.isSupported(context)) {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
        if (suffix.equals("")) {
            throw new IllegalArgumentException("Suffix cannot be an empty string");
        }
        if (suffix.indexOf(File.separatorChar) >= 0) {
            throw new IllegalArgumentException("Suffix " + suffix + " contains a path separator");
        }
        this.mDataDirectorySuffix = suffix;
        return this;
    }

    @NonNull
    public ProcessGlobalConfig setDirectoryBasePaths(@NonNull Context context, @NonNull File dataDirectoryBasePath, @NonNull File cacheDirectoryBasePath) {
        StartupApiFeature.NoFramework feature = WebViewFeatureInternal.STARTUP_FEATURE_SET_DIRECTORY_BASE_PATH;
        if (!feature.isSupported(context)) {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
        if (!dataDirectoryBasePath.isAbsolute()) {
            throw new IllegalArgumentException("dataDirectoryBasePath must be a non-empty absolute path");
        }
        if (!cacheDirectoryBasePath.isAbsolute()) {
            throw new IllegalArgumentException("cacheDirectoryBasePath must be a non-empty absolute path");
        }
        this.mDataDirectoryBasePath = dataDirectoryBasePath.getAbsolutePath();
        this.mCacheDirectoryBasePath = cacheDirectoryBasePath.getAbsolutePath();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(@NonNull ProcessGlobalConfig config) {
        Object object = sLock;
        synchronized (object) {
            if (sApplyCalled) {
                throw new IllegalStateException("ProcessGlobalConfig#apply was called more than once, which is an illegal operation. The configuration settings provided by ProcessGlobalConfig take effect only once, when WebView is first loaded into the current process. Every process should only ever create a single instance of ProcessGlobalConfig and apply it once, before any calls to android.webkit APIs, such as during early app startup.");
            }
            sApplyCalled = true;
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (ProcessGlobalConfig.webViewCurrentlyLoaded()) {
            throw new IllegalStateException("WebView has already been loaded in the current process, so any attempt to apply the settings in ProcessGlobalConfig will have no effect. ProcessGlobalConfig#apply needs to be called before any calls to android.webkit APIs, such as during early app startup.");
        }
        if (config.mDataDirectorySuffix != null) {
            StartupApiFeature.P feature = WebViewFeatureInternal.STARTUP_FEATURE_SET_DATA_DIRECTORY_SUFFIX;
            if (feature.isSupportedByFramework()) {
                ApiHelperForP.setDataDirectorySuffix(config.mDataDirectorySuffix);
            } else {
                configMap.put("DATA_DIRECTORY_SUFFIX", config.mDataDirectorySuffix);
            }
        }
        if (config.mDataDirectoryBasePath != null) {
            configMap.put("DATA_DIRECTORY_BASE_PATH", config.mDataDirectoryBasePath);
        }
        if (config.mCacheDirectoryBasePath != null) {
            configMap.put("CACHE_DIRECTORY_BASE_PATH", config.mCacheDirectoryBasePath);
        }
        if (!sProcessGlobalConfig.compareAndSet(null, configMap)) {
            throw new RuntimeException("Attempting to set ProcessGlobalConfig#sProcessGlobalConfig when it was already set");
        }
    }

    private static boolean webViewCurrentlyLoaded() {
        try {
            Class<?> webViewFactoryClass = Class.forName("android.webkit.WebViewFactory");
            Field providerInstanceField = webViewFactoryClass.getDeclaredField("sProviderInstance");
            providerInstanceField.setAccessible(true);
            return providerInstanceField.get(null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

