/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.webkit.WebMessagePortCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class WebMessageCompat {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_ARRAY_BUFFER = 1;
    @Nullable
    private final WebMessagePortCompat[] mPorts;
    @Nullable
    private final String mString;
    @Nullable
    private final byte[] mArrayBuffer;
    private final int mType;

    public WebMessageCompat(@Nullable String data) {
        this(data, null);
    }

    public WebMessageCompat(@Nullable String data, @Nullable WebMessagePortCompat[] ports) {
        this.mString = data;
        this.mArrayBuffer = null;
        this.mPorts = ports;
        this.mType = 0;
    }

    public WebMessageCompat(@NonNull byte[] arrayBuffer) {
        this(arrayBuffer, null);
    }

    public WebMessageCompat(@NonNull byte[] arrayBuffer, @Nullable WebMessagePortCompat[] ports) {
        Objects.requireNonNull(arrayBuffer);
        this.mArrayBuffer = arrayBuffer;
        this.mString = null;
        this.mPorts = ports;
        this.mType = 1;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public byte[] getArrayBuffer() {
        this.checkType(1);
        Objects.requireNonNull(this.mArrayBuffer);
        return this.mArrayBuffer;
    }

    @Nullable
    public String getData() {
        this.checkType(0);
        return this.mString;
    }

    @Nullable
    public WebMessagePortCompat[] getPorts() {
        return this.mPorts;
    }

    @NonNull
    private String typeToString(int type) {
        switch (type) {
            case 0: {
                return "String";
            }
            case 1: {
                return "ArrayBuffer";
            }
        }
        return "Unknown";
    }

    private void checkType(int typeForGetter) {
        if (typeForGetter != this.mType) {
            throw new IllegalStateException("Wrong data accessor type detected. " + this.typeToString(this.mType) + " expected, but got " + this.typeToString(typeForGetter));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Type {
    }
}

