/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import android.app.PendingIntent;
import android.os.Build;
import android.webkit.SafeBrowsingResponse;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.webkit.SafeBrowsingResponseCompat;
import androidx.webkit.WebResourceErrorCompat;
import androidx.webkit.WebViewFeature;
import androidx.webkit.internal.ApiHelperForLollipop;
import androidx.webkit.internal.SafeBrowsingResponseImpl;
import androidx.webkit.internal.WebResourceErrorImpl;
import androidx.webkit.internal.WebViewFeatureInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import org.chromium.support_lib_boundary.WebViewClientBoundaryInterface;

public class WebViewClientCompat
extends WebViewClient
implements WebViewClientBoundaryInterface {
    private static final String[] sSupportedFeatures = new String[]{"VISUAL_STATE_CALLBACK", "RECEIVE_WEB_RESOURCE_ERROR", "RECEIVE_HTTP_ERROR", "SHOULD_OVERRIDE_WITH_REDIRECTS", "SAFE_BROWSING_HIT"};

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public final String[] getSupportedFeatures() {
        return sSupportedFeatures;
    }

    @Override
    @UiThread
    public void onPageCommitVisible(@NonNull WebView view, @NonNull String url) {
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=21)
    public final void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull InvocationHandler handler) {
        this.onReceivedError(view, request, new WebResourceErrorImpl(handler));
    }

    @RequiresApi(value=23)
    public final void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceError error) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        this.onReceivedError(view, request, new WebResourceErrorImpl(error));
    }

    @RequiresApi(value=21)
    @UiThread
    public void onReceivedError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceErrorCompat error) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (!WebViewFeature.isFeatureSupported("WEB_RESOURCE_ERROR_GET_CODE") || !WebViewFeature.isFeatureSupported("WEB_RESOURCE_ERROR_GET_DESCRIPTION")) {
            return;
        }
        if (ApiHelperForLollipop.isForMainFrame(request)) {
            this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), ApiHelperForLollipop.getUrl(request).toString());
        }
    }

    @Override
    @UiThread
    public void onReceivedHttpError(@NonNull WebView view, @NonNull WebResourceRequest request, @NonNull WebResourceResponse errorResponse) {
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onSafeBrowsingHit(@NonNull WebView view, @NonNull WebResourceRequest request, int threatType, @NonNull InvocationHandler handler) {
        this.onSafeBrowsingHit(view, request, threatType, new SafeBrowsingResponseImpl(handler));
    }

    @RequiresApi(value=27)
    public final void onSafeBrowsingHit(@NonNull WebView view, @NonNull WebResourceRequest request, int threatType, @NonNull SafeBrowsingResponse response) {
        this.onSafeBrowsingHit(view, request, threatType, new SafeBrowsingResponseImpl(response));
    }

    @UiThread
    public void onSafeBrowsingHit(@NonNull WebView view, @NonNull WebResourceRequest request, int threatType, @NonNull SafeBrowsingResponseCompat callback) {
        if (!WebViewFeature.isFeatureSupported("SAFE_BROWSING_RESPONSE_SHOW_INTERSTITIAL")) {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
        callback.showInterstitial(true);
    }

    @Override
    @RequiresApi(value=21)
    @UiThread
    public boolean shouldOverrideUrlLoading(@NonNull WebView view, @NonNull WebResourceRequest request) {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.shouldOverrideUrlLoading(view, ApiHelperForLollipop.getUrl(request).toString());
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean onWebAuthnIntent(@NonNull WebView view, @NonNull PendingIntent intent, @NonNull InvocationHandler callback) {
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface SafeBrowsingThreat {
    }
}

