/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.net.Uri;
import android.os.Handler;
import android.webkit.WebMessage;
import android.webkit.WebMessagePort;
import android.webkit.WebResourceError;
import android.webkit.WebSettings;
import android.webkit.WebView;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.webkit.WebMessageCompat;
import androidx.webkit.WebMessagePortCompat;
import androidx.webkit.WebViewCompat;
import androidx.webkit.internal.WebMessagePortImpl;

@RequiresApi(value=23)
public class ApiHelperForM {
    private ApiHelperForM() {
    }

    @DoNotInline
    public static void postMessage(@NonNull WebMessagePort webMessagePort, @NonNull WebMessage webMessage) {
        webMessagePort.postMessage(webMessage);
    }

    @DoNotInline
    public static void close(@NonNull WebMessagePort webMessagePort) {
        webMessagePort.close();
    }

    @DoNotInline
    public static void setWebMessageCallback(@NonNull WebMessagePort frameworksImpl, final @NonNull WebMessagePortCompat.WebMessageCallbackCompat callback) {
        frameworksImpl.setWebMessageCallback(new WebMessagePort.WebMessageCallback(){

            public void onMessage(WebMessagePort port, WebMessage message) {
                callback.onMessage(new WebMessagePortImpl(port), WebMessagePortImpl.frameworkMessageToCompat(message));
            }
        });
    }

    @DoNotInline
    public static void setWebMessageCallback(@NonNull WebMessagePort frameworksImpl, final @NonNull WebMessagePortCompat.WebMessageCallbackCompat callback, @Nullable Handler handler) {
        frameworksImpl.setWebMessageCallback(new WebMessagePort.WebMessageCallback(){

            public void onMessage(WebMessagePort port, WebMessage message) {
                callback.onMessage(new WebMessagePortImpl(port), WebMessagePortImpl.frameworkMessageToCompat(message));
            }
        }, handler);
    }

    @DoNotInline
    @NonNull
    public static WebMessage createWebMessage(@NonNull WebMessageCompat message) {
        return new WebMessage(message.getData(), WebMessagePortImpl.compatToPorts(message.getPorts()));
    }

    @DoNotInline
    @NonNull
    public static WebMessageCompat createWebMessageCompat(@NonNull WebMessage webMessage) {
        return new WebMessageCompat(webMessage.getData(), WebMessagePortImpl.portsToCompat(webMessage.getPorts()));
    }

    @DoNotInline
    public static int getErrorCode(@NonNull WebResourceError webResourceError) {
        return webResourceError.getErrorCode();
    }

    @DoNotInline
    @NonNull
    public static CharSequence getDescription(@NonNull WebResourceError webResourceError) {
        return webResourceError.getDescription();
    }

    @DoNotInline
    public static void setOffscreenPreRaster(@NonNull WebSettings webSettings, boolean b) {
        webSettings.setOffscreenPreRaster(b);
    }

    @DoNotInline
    public static boolean getOffscreenPreRaster(@NonNull WebSettings webSettings) {
        return webSettings.getOffscreenPreRaster();
    }

    @DoNotInline
    public static void postVisualStateCallback(@NonNull WebView webView, long requestId, final @NonNull WebViewCompat.VisualStateCallback callback) {
        webView.postVisualStateCallback(requestId, new WebView.VisualStateCallback(){

            public void onComplete(long l) {
                callback.onComplete(l);
            }
        });
    }

    @DoNotInline
    public static void postWebMessage(@NonNull WebView webView, @NonNull WebMessage message, @NonNull Uri targetOrigin) {
        webView.postWebMessage(message, targetOrigin);
    }

    @DoNotInline
    @NonNull
    public static WebMessagePort[] createWebMessageChannel(@NonNull WebView webView) {
        return webView.createWebMessageChannel();
    }
}

