/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.webkit.Profile;
import androidx.webkit.ProfileStore;
import androidx.webkit.internal.ApiFeature;
import androidx.webkit.internal.ProfileImpl;
import androidx.webkit.internal.WebViewFeatureInternal;
import androidx.webkit.internal.WebViewGlueCommunicator;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import org.chromium.support_lib_boundary.ProfileBoundaryInterface;
import org.chromium.support_lib_boundary.ProfileStoreBoundaryInterface;
import org.chromium.support_lib_boundary.util.BoundaryInterfaceReflectionUtil;

public class ProfileStoreImpl
implements ProfileStore {
    private final ProfileStoreBoundaryInterface mProfileStoreImpl;
    private static ProfileStore sInstance;

    private ProfileStoreImpl(ProfileStoreBoundaryInterface profileStoreImpl) {
        this.mProfileStoreImpl = profileStoreImpl;
    }

    private ProfileStoreImpl() {
        this.mProfileStoreImpl = null;
    }

    @NonNull
    public static ProfileStore getInstance() {
        if (sInstance == null) {
            sInstance = new ProfileStoreImpl(WebViewGlueCommunicator.getFactory().getProfileStore());
        }
        return sInstance;
    }

    @Override
    @NonNull
    public Profile getOrCreateProfile(@NonNull String name) {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.MULTI_PROFILE;
        if (feature.isSupportedByWebView()) {
            return new ProfileImpl(BoundaryInterfaceReflectionUtil.castToSuppLibClass(ProfileBoundaryInterface.class, this.mProfileStoreImpl.getOrCreateProfile(name)));
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    @Nullable
    public Profile getProfile(@NonNull String name) {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.MULTI_PROFILE;
        if (feature.isSupportedByWebView()) {
            InvocationHandler profileBoundaryInterface = this.mProfileStoreImpl.getProfile(name);
            if (profileBoundaryInterface != null) {
                return new ProfileImpl(BoundaryInterfaceReflectionUtil.castToSuppLibClass(ProfileBoundaryInterface.class, profileBoundaryInterface));
            }
            return null;
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<String> getAllProfileNames() {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.MULTI_PROFILE;
        if (feature.isSupportedByWebView()) {
            return this.mProfileStoreImpl.getAllProfileNames();
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    public boolean deleteProfile(@NonNull String name) throws IllegalStateException {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.MULTI_PROFILE;
        if (feature.isSupportedByWebView()) {
            return this.mProfileStoreImpl.deleteProfile(name);
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }
}

