/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.webkit.ProxyConfig;
import androidx.webkit.ProxyController;
import androidx.webkit.internal.ApiFeature;
import androidx.webkit.internal.WebViewFeatureInternal;
import androidx.webkit.internal.WebViewGlueCommunicator;
import java.util.List;
import java.util.concurrent.Executor;
import org.chromium.support_lib_boundary.ProxyControllerBoundaryInterface;

public class ProxyControllerImpl
extends ProxyController {
    private ProxyControllerBoundaryInterface mBoundaryInterface;

    @Override
    public void setProxyOverride(@NonNull ProxyConfig proxyConfig, @NonNull Executor executor, @NonNull Runnable listener) {
        ApiFeature.NoFramework proxyOverride = WebViewFeatureInternal.PROXY_OVERRIDE;
        ApiFeature.NoFramework reverseBypass = WebViewFeatureInternal.PROXY_OVERRIDE_REVERSE_BYPASS;
        String[][] proxyRuleArray = ProxyControllerImpl.proxyRulesToStringArray(proxyConfig.getProxyRules());
        String[] bypassRuleArray = proxyConfig.getBypassRules().toArray(new String[0]);
        if (proxyOverride.isSupportedByWebView() && !proxyConfig.isReverseBypassEnabled()) {
            this.getBoundaryInterface().setProxyOverride(proxyRuleArray, bypassRuleArray, listener, executor);
        } else if (proxyOverride.isSupportedByWebView() && reverseBypass.isSupportedByWebView()) {
            this.getBoundaryInterface().setProxyOverride(proxyRuleArray, bypassRuleArray, listener, executor, proxyConfig.isReverseBypassEnabled());
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public void clearProxyOverride(@NonNull Executor executor, @NonNull Runnable listener) {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.PROXY_OVERRIDE;
        if (!feature.isSupportedByWebView()) {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
        this.getBoundaryInterface().clearProxyOverride(listener, executor);
    }

    @NonNull
    @VisibleForTesting
    public static String[][] proxyRulesToStringArray(@NonNull List<ProxyConfig.ProxyRule> proxyRuleList) {
        String[][] proxyRuleArray = new String[proxyRuleList.size()][2];
        for (int i = 0; i < proxyRuleList.size(); ++i) {
            proxyRuleArray[i][0] = proxyRuleList.get(i).getSchemeFilter();
            proxyRuleArray[i][1] = proxyRuleList.get(i).getUrl();
        }
        return proxyRuleArray;
    }

    private ProxyControllerBoundaryInterface getBoundaryInterface() {
        if (this.mBoundaryInterface == null) {
            this.mBoundaryInterface = WebViewGlueCommunicator.getFactory().getProxyController();
        }
        return this.mBoundaryInterface;
    }
}

