/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.webkit.SafeBrowsingResponse;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.webkit.SafeBrowsingResponseCompat;
import androidx.webkit.internal.ApiFeature;
import androidx.webkit.internal.ApiHelperForOMR1;
import androidx.webkit.internal.WebViewFeatureInternal;
import androidx.webkit.internal.WebViewGlueCommunicator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.chromium.support_lib_boundary.SafeBrowsingResponseBoundaryInterface;
import org.chromium.support_lib_boundary.util.BoundaryInterfaceReflectionUtil;

public class SafeBrowsingResponseImpl
extends SafeBrowsingResponseCompat {
    private SafeBrowsingResponse mFrameworksImpl;
    private SafeBrowsingResponseBoundaryInterface mBoundaryInterface;

    public SafeBrowsingResponseImpl(@NonNull InvocationHandler invocationHandler) {
        this.mBoundaryInterface = BoundaryInterfaceReflectionUtil.castToSuppLibClass(SafeBrowsingResponseBoundaryInterface.class, invocationHandler);
    }

    public SafeBrowsingResponseImpl(@NonNull SafeBrowsingResponse response) {
        this.mFrameworksImpl = response;
    }

    @RequiresApi(value=27)
    private SafeBrowsingResponse getFrameworksImpl() {
        if (this.mFrameworksImpl == null) {
            this.mFrameworksImpl = WebViewGlueCommunicator.getCompatConverter().convertSafeBrowsingResponse(Proxy.getInvocationHandler(this.mBoundaryInterface));
        }
        return this.mFrameworksImpl;
    }

    private SafeBrowsingResponseBoundaryInterface getBoundaryInterface() {
        if (this.mBoundaryInterface == null) {
            this.mBoundaryInterface = BoundaryInterfaceReflectionUtil.castToSuppLibClass(SafeBrowsingResponseBoundaryInterface.class, WebViewGlueCommunicator.getCompatConverter().convertSafeBrowsingResponse(this.mFrameworksImpl));
        }
        return this.mBoundaryInterface;
    }

    @Override
    public void showInterstitial(boolean allowReporting) {
        ApiFeature.O_MR1 feature = WebViewFeatureInternal.SAFE_BROWSING_RESPONSE_SHOW_INTERSTITIAL;
        if (feature.isSupportedByFramework()) {
            ApiHelperForOMR1.showInterstitial(this.getFrameworksImpl(), allowReporting);
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().showInterstitial(allowReporting);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public void proceed(boolean report) {
        ApiFeature.O_MR1 feature = WebViewFeatureInternal.SAFE_BROWSING_RESPONSE_PROCEED;
        if (feature.isSupportedByFramework()) {
            ApiHelperForOMR1.proceed(this.getFrameworksImpl(), report);
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().proceed(report);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public void backToSafety(boolean report) {
        ApiFeature.O_MR1 feature = WebViewFeatureInternal.SAFE_BROWSING_RESPONSE_BACK_TO_SAFETY;
        if (feature.isSupportedByFramework()) {
            ApiHelperForOMR1.backToSafety(this.getFrameworksImpl(), report);
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().backToSafety(report);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }
}

