/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.webkit.ServiceWorkerWebSettings;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.webkit.ServiceWorkerWebSettingsCompat;
import androidx.webkit.internal.ApiFeature;
import androidx.webkit.internal.ApiHelperForN;
import androidx.webkit.internal.WebViewFeatureInternal;
import androidx.webkit.internal.WebViewGlueCommunicator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Set;
import org.chromium.support_lib_boundary.ServiceWorkerWebSettingsBoundaryInterface;
import org.chromium.support_lib_boundary.util.BoundaryInterfaceReflectionUtil;

public class ServiceWorkerWebSettingsImpl
extends ServiceWorkerWebSettingsCompat {
    private ServiceWorkerWebSettings mFrameworksImpl;
    private ServiceWorkerWebSettingsBoundaryInterface mBoundaryInterface;

    public ServiceWorkerWebSettingsImpl(@NonNull ServiceWorkerWebSettings settings) {
        this.mFrameworksImpl = settings;
    }

    public ServiceWorkerWebSettingsImpl(@NonNull InvocationHandler invocationHandler) {
        this.mBoundaryInterface = BoundaryInterfaceReflectionUtil.castToSuppLibClass(ServiceWorkerWebSettingsBoundaryInterface.class, invocationHandler);
    }

    @RequiresApi(value=24)
    private ServiceWorkerWebSettings getFrameworksImpl() {
        if (this.mFrameworksImpl == null) {
            this.mFrameworksImpl = WebViewGlueCommunicator.getCompatConverter().convertServiceWorkerSettings(Proxy.getInvocationHandler(this.mBoundaryInterface));
        }
        return this.mFrameworksImpl;
    }

    private ServiceWorkerWebSettingsBoundaryInterface getBoundaryInterface() {
        if (this.mBoundaryInterface == null) {
            this.mBoundaryInterface = BoundaryInterfaceReflectionUtil.castToSuppLibClass(ServiceWorkerWebSettingsBoundaryInterface.class, WebViewGlueCommunicator.getCompatConverter().convertServiceWorkerSettings(this.mFrameworksImpl));
        }
        return this.mBoundaryInterface;
    }

    @Override
    public void setCacheMode(int mode) {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_CACHE_MODE;
        if (feature.isSupportedByFramework()) {
            ApiHelperForN.setCacheMode(this.getFrameworksImpl(), mode);
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().setCacheMode(mode);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public int getCacheMode() {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_CACHE_MODE;
        if (feature.isSupportedByFramework()) {
            return ApiHelperForN.getCacheMode(this.getFrameworksImpl());
        }
        if (feature.isSupportedByWebView()) {
            return this.getBoundaryInterface().getCacheMode();
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    public void setAllowContentAccess(boolean allow) {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_CONTENT_ACCESS;
        if (feature.isSupportedByFramework()) {
            ApiHelperForN.setAllowContentAccess(this.getFrameworksImpl(), allow);
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().setAllowContentAccess(allow);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public boolean getAllowContentAccess() {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_CONTENT_ACCESS;
        if (feature.isSupportedByFramework()) {
            return ApiHelperForN.getAllowContentAccess(this.getFrameworksImpl());
        }
        if (feature.isSupportedByWebView()) {
            return this.getBoundaryInterface().getAllowContentAccess();
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    public void setAllowFileAccess(boolean allow) {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_FILE_ACCESS;
        if (feature.isSupportedByFramework()) {
            ApiHelperForN.setAllowFileAccess(this.getFrameworksImpl(), allow);
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().setAllowFileAccess(allow);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public boolean getAllowFileAccess() {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_FILE_ACCESS;
        if (feature.isSupportedByFramework()) {
            return ApiHelperForN.getAllowFileAccess(this.getFrameworksImpl());
        }
        if (feature.isSupportedByWebView()) {
            return this.getBoundaryInterface().getAllowFileAccess();
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    public void setBlockNetworkLoads(boolean flag) {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_BLOCK_NETWORK_LOADS;
        if (feature.isSupportedByFramework()) {
            ApiHelperForN.setBlockNetworkLoads(this.getFrameworksImpl(), flag);
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().setBlockNetworkLoads(flag);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public boolean getBlockNetworkLoads() {
        ApiFeature.N feature = WebViewFeatureInternal.SERVICE_WORKER_BLOCK_NETWORK_LOADS;
        if (feature.isSupportedByFramework()) {
            return ApiHelperForN.getBlockNetworkLoads(this.getFrameworksImpl());
        }
        if (feature.isSupportedByWebView()) {
            return this.getBoundaryInterface().getBlockNetworkLoads();
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    @NonNull
    public Set<String> getRequestedWithHeaderOriginAllowList() {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.REQUESTED_WITH_HEADER_ALLOW_LIST;
        if (feature.isSupportedByWebView()) {
            return this.getBoundaryInterface().getRequestedWithHeaderOriginAllowList();
        }
        throw WebViewFeatureInternal.getUnsupportedOperationException();
    }

    @Override
    public void setRequestedWithHeaderOriginAllowList(@NonNull Set<String> allowList) {
        ApiFeature.NoFramework feature = WebViewFeatureInternal.REQUESTED_WITH_HEADER_ALLOW_LIST;
        if (!feature.isSupportedByWebView()) {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
        this.getBoundaryInterface().setRequestedWithHeaderOriginAllowList(allowList);
    }
}

