/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import androidx.annotation.NonNull;
import androidx.webkit.UserAgentMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserAgentMetadataInternal {
    private static final String MOBILE = "MOBILE";
    private static final String BRAND_VERSION_LIST = "BRAND_VERSION_LIST";
    private static final String FULL_VERSION = "FULL_VERSION";
    private static final String PLATFORM = "PLATFORM";
    private static final String PLATFORM_VERSION = "PLATFORM_VERSION";
    private static final String ARCHITECTURE = "ARCHITECTURE";
    private static final String MODEL = "MODEL";
    private static final String BITNESS = "BITNESS";
    private static final String WOW64 = "WOW64";
    private static final int BRAND_VERSION_LENGTH = 3;

    @NonNull
    static Map<String, Object> convertUserAgentMetadataToMap(@NonNull UserAgentMetadata uaMetadata) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(BRAND_VERSION_LIST, UserAgentMetadataInternal.getBrandVersionArray(uaMetadata.getBrandVersionList()));
        item.put(FULL_VERSION, uaMetadata.getFullVersion());
        item.put(PLATFORM, uaMetadata.getPlatform());
        item.put(PLATFORM_VERSION, uaMetadata.getPlatformVersion());
        item.put(ARCHITECTURE, uaMetadata.getArchitecture());
        item.put(MODEL, uaMetadata.getModel());
        item.put(MOBILE, uaMetadata.isMobile());
        item.put(BITNESS, uaMetadata.getBitness());
        item.put(WOW64, uaMetadata.isWow64());
        return item;
    }

    private static String[][] getBrandVersionArray(List<UserAgentMetadata.BrandVersion> brandVersionList) {
        if (brandVersionList == null || brandVersionList.isEmpty()) {
            return null;
        }
        String[][] brandVersionArray = new String[brandVersionList.size()][3];
        for (int i = 0; i < brandVersionList.size(); ++i) {
            brandVersionArray[i][0] = brandVersionList.get(i).getBrand();
            brandVersionArray[i][1] = brandVersionList.get(i).getMajorVersion();
            brandVersionArray[i][2] = brandVersionList.get(i).getFullVersion();
        }
        return brandVersionArray;
    }

    @NonNull
    static UserAgentMetadata getUserAgentMetadataFromMap(@NonNull Map<String, Object> uaMetadataMap) {
        Boolean isWow64;
        Integer bitness;
        Boolean isMobile;
        String model;
        String architecture;
        String platformVersion;
        String platform;
        String fullVersion;
        UserAgentMetadata.Builder builder = new UserAgentMetadata.Builder();
        Object brandVersionValue = uaMetadataMap.get(BRAND_VERSION_LIST);
        if (brandVersionValue != null) {
            String[][] overrideBrandVersionList = (String[][])brandVersionValue;
            ArrayList<UserAgentMetadata.BrandVersion> brandVersionList = new ArrayList<UserAgentMetadata.BrandVersion>();
            for (String[] brandVersionInfo : overrideBrandVersionList) {
                brandVersionList.add(new UserAgentMetadata.BrandVersion.Builder().setBrand(brandVersionInfo[0]).setMajorVersion(brandVersionInfo[1]).setFullVersion(brandVersionInfo[2]).build());
            }
            builder.setBrandVersionList(brandVersionList);
        }
        if ((fullVersion = (String)uaMetadataMap.get(FULL_VERSION)) != null) {
            builder.setFullVersion(fullVersion);
        }
        if ((platform = (String)uaMetadataMap.get(PLATFORM)) != null) {
            builder.setPlatform(platform);
        }
        if ((platformVersion = (String)uaMetadataMap.get(PLATFORM_VERSION)) != null) {
            builder.setPlatformVersion(platformVersion);
        }
        if ((architecture = (String)uaMetadataMap.get(ARCHITECTURE)) != null) {
            builder.setArchitecture(architecture);
        }
        if ((model = (String)uaMetadataMap.get(MODEL)) != null) {
            builder.setModel(model);
        }
        if ((isMobile = (Boolean)uaMetadataMap.get(MOBILE)) != null) {
            builder.setMobile(isMobile);
        }
        if ((bitness = (Integer)uaMetadataMap.get(BITNESS)) != null) {
            builder.setBitness(bitness);
        }
        if ((isWow64 = (Boolean)uaMetadataMap.get(WOW64)) != null) {
            builder.setWow64(isWow64);
        }
        return builder.build();
    }
}

