/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.webkit.WebMessageCompat;
import androidx.webkit.WebMessagePortCompat;
import androidx.webkit.internal.WebMessagePayloadAdapter;
import androidx.webkit.internal.WebMessagePortImpl;
import androidx.webkit.internal.WebViewFeatureInternal;
import java.lang.reflect.InvocationHandler;
import java.util.Objects;
import org.chromium.support_lib_boundary.WebMessageBoundaryInterface;
import org.chromium.support_lib_boundary.WebMessagePayloadBoundaryInterface;
import org.chromium.support_lib_boundary.util.BoundaryInterfaceReflectionUtil;

public class WebMessageAdapter
implements WebMessageBoundaryInterface {
    private WebMessageCompat mWebMessageCompat;
    private static final String[] sFeatures = new String[]{"WEB_MESSAGE_ARRAY_BUFFER"};

    public WebMessageAdapter(@NonNull WebMessageCompat webMessage) {
        this.mWebMessageCompat = webMessage;
    }

    @Override
    @Deprecated
    @Nullable
    public String getData() {
        return this.mWebMessageCompat.getData();
    }

    @Override
    @RequiresApi(api=19)
    @Nullable
    public InvocationHandler getMessagePayload() {
        WebMessagePayloadAdapter adapter;
        switch (this.mWebMessageCompat.getType()) {
            case 0: {
                adapter = new WebMessagePayloadAdapter(this.mWebMessageCompat.getData());
                break;
            }
            case 1: {
                adapter = new WebMessagePayloadAdapter(Objects.requireNonNull(this.mWebMessageCompat.getArrayBuffer()));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown web message payload type: " + this.mWebMessageCompat.getType());
            }
        }
        return BoundaryInterfaceReflectionUtil.createInvocationHandlerFor(adapter);
    }

    @Override
    @Nullable
    public InvocationHandler[] getPorts() {
        WebMessagePortCompat[] ports = this.mWebMessageCompat.getPorts();
        if (ports == null) {
            return null;
        }
        InvocationHandler[] invocationHandlers = new InvocationHandler[ports.length];
        for (int n = 0; n < ports.length; ++n) {
            invocationHandlers[n] = ports[n].getInvocationHandler();
        }
        return invocationHandlers;
    }

    @Override
    @NonNull
    public String[] getSupportedFeatures() {
        return sFeatures;
    }

    public static boolean isMessagePayloadTypeSupportedByWebView(int type) {
        return type == 0 || type == 1 && WebViewFeatureInternal.WEB_MESSAGE_ARRAY_BUFFER.isSupportedByWebView();
    }

    @Nullable
    public static WebMessageCompat webMessageCompatFromBoundaryInterface(@NonNull WebMessageBoundaryInterface boundaryInterface) {
        WebMessagePortCompat[] ports = WebMessageAdapter.toWebMessagePortCompats(boundaryInterface.getPorts());
        if (WebViewFeatureInternal.WEB_MESSAGE_ARRAY_BUFFER.isSupportedByWebView()) {
            WebMessagePayloadBoundaryInterface payloadInterface = BoundaryInterfaceReflectionUtil.castToSuppLibClass(WebMessagePayloadBoundaryInterface.class, boundaryInterface.getMessagePayload());
            int type = payloadInterface.getType();
            switch (type) {
                case 0: {
                    return new WebMessageCompat(payloadInterface.getAsString(), ports);
                }
                case 1: {
                    return new WebMessageCompat(payloadInterface.getAsArrayBuffer(), ports);
                }
            }
            return null;
        }
        return new WebMessageCompat(boundaryInterface.getData(), ports);
    }

    @NonNull
    private static WebMessagePortCompat[] toWebMessagePortCompats(InvocationHandler[] ports) {
        WebMessagePortCompat[] compatPorts = new WebMessagePortCompat[ports.length];
        for (int n = 0; n < ports.length; ++n) {
            compatPorts[n] = new WebMessagePortImpl(ports[n]);
        }
        return compatPorts;
    }
}

