/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.annotation.SuppressLint;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.webkit.WebViewRenderProcessClient;
import androidx.webkit.internal.WebViewRenderProcessImpl;
import java.lang.reflect.InvocationHandler;
import java.util.concurrent.Executor;
import org.chromium.support_lib_boundary.WebViewRendererClientBoundaryInterface;

public class WebViewRenderProcessClientAdapter
implements WebViewRendererClientBoundaryInterface {
    private static final String[] sSupportedFeatures = new String[]{"WEB_VIEW_RENDERER_CLIENT_BASIC_USAGE"};
    private final Executor mExecutor;
    private final WebViewRenderProcessClient mWebViewRenderProcessClient;

    @SuppressLint(value={"LambdaLast"})
    public WebViewRenderProcessClientAdapter(@Nullable Executor executor, @Nullable WebViewRenderProcessClient webViewRenderProcessClient) {
        this.mExecutor = executor;
        this.mWebViewRenderProcessClient = webViewRenderProcessClient;
    }

    @Nullable
    public WebViewRenderProcessClient getWebViewRenderProcessClient() {
        return this.mWebViewRenderProcessClient;
    }

    @Override
    @NonNull
    public final String[] getSupportedFeatures() {
        return sSupportedFeatures;
    }

    @Override
    public final void onRendererUnresponsive(final @NonNull WebView view, @NonNull InvocationHandler renderer) {
        final WebViewRenderProcessImpl rendererObject = WebViewRenderProcessImpl.forInvocationHandler(renderer);
        final WebViewRenderProcessClient client = this.mWebViewRenderProcessClient;
        if (this.mExecutor == null) {
            client.onRenderProcessUnresponsive(view, rendererObject);
        } else {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    client.onRenderProcessUnresponsive(view, rendererObject);
                }
            });
        }
    }

    @Override
    public final void onRendererResponsive(final @NonNull WebView view, @NonNull InvocationHandler renderer) {
        final WebViewRenderProcessImpl rendererObject = WebViewRenderProcessImpl.forInvocationHandler(renderer);
        final WebViewRenderProcessClient client = this.mWebViewRenderProcessClient;
        if (this.mExecutor == null) {
            client.onRenderProcessResponsive(view, rendererObject);
        } else {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    client.onRenderProcessResponsive(view, rendererObject);
                }
            });
        }
    }
}

