/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TracingConfig {
    public static final int CATEGORIES_NONE = 0;
    public static final int CATEGORIES_ALL = 1;
    public static final int CATEGORIES_ANDROID_WEBVIEW = 2;
    public static final int CATEGORIES_WEB_DEVELOPER = 4;
    public static final int CATEGORIES_INPUT_LATENCY = 8;
    public static final int CATEGORIES_RENDERING = 16;
    public static final int CATEGORIES_JAVASCRIPT_AND_RENDERING = 32;
    public static final int CATEGORIES_FRAME_VIEWER = 64;
    public static final int RECORD_UNTIL_FULL = 0;
    public static final int RECORD_CONTINUOUSLY = 1;
    private int mPredefinedCategories;
    private final List<String> mCustomIncludedCategories = new ArrayList<String>();
    private int mTracingMode;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public TracingConfig(int predefinedCategories, @NonNull List<String> customIncludedCategories, int tracingMode) {
        this.mPredefinedCategories = predefinedCategories;
        this.mCustomIncludedCategories.addAll(customIncludedCategories);
        this.mTracingMode = tracingMode;
    }

    public int getPredefinedCategories() {
        return this.mPredefinedCategories;
    }

    @NonNull
    public List<String> getCustomIncludedCategories() {
        return this.mCustomIncludedCategories;
    }

    public int getTracingMode() {
        return this.mTracingMode;
    }

    public static class Builder {
        private int mPredefinedCategories = 0;
        private final List<String> mCustomIncludedCategories = new ArrayList<String>();
        private int mTracingMode = 1;

        @NonNull
        public TracingConfig build() {
            return new TracingConfig(this.mPredefinedCategories, this.mCustomIncludedCategories, this.mTracingMode);
        }

        @NonNull
        public Builder addCategories(int ... predefinedCategories) {
            for (int categorySet : predefinedCategories) {
                this.mPredefinedCategories |= categorySet;
            }
            return this;
        }

        @NonNull
        public Builder addCategories(String ... categories) {
            this.mCustomIncludedCategories.addAll(Arrays.asList(categories));
            return this;
        }

        @NonNull
        public Builder addCategories(@NonNull Collection<String> categories) {
            this.mCustomIncludedCategories.addAll(categories);
            return this;
        }

        @NonNull
        public Builder setTracingMode(int tracingMode) {
            this.mTracingMode = tracingMode;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface TracingMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface PredefinedCategories {
    }
}

