/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.util.Log;
import android.webkit.WebResourceResponse;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.util.Pair;
import androidx.webkit.internal.AssetHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class WebViewAssetLoader {
    private static final String TAG = "WebViewAssetLoader";
    public static final String DEFAULT_DOMAIN = "appassets.androidplatform.net";
    private final List<PathMatcher> mMatchers;

    WebViewAssetLoader(@NonNull List<PathMatcher> pathMatchers) {
        this.mMatchers = pathMatchers;
    }

    @WorkerThread
    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NonNull Uri url) {
        for (PathMatcher matcher : this.mMatchers) {
            String suffixPath;
            WebResourceResponse response;
            PathHandler handler = matcher.match(url);
            if (handler == null || (response = handler.handle(suffixPath = matcher.getSuffixPath(url.getPath()))) == null) continue;
            return response;
        }
        return null;
    }

    @VisibleForTesting
    static class PathMatcher {
        static final String HTTP_SCHEME = "http";
        static final String HTTPS_SCHEME = "https";
        final boolean mHttpEnabled;
        @NonNull
        final String mAuthority;
        @NonNull
        final String mPath;
        @NonNull
        final PathHandler mHandler;

        PathMatcher(@NonNull String authority, @NonNull String path, boolean httpEnabled, @NonNull PathHandler handler) {
            if (path.isEmpty() || path.charAt(0) != '/') {
                throw new IllegalArgumentException("Path should start with a slash '/'.");
            }
            if (!path.endsWith("/")) {
                throw new IllegalArgumentException("Path should end with a slash '/'");
            }
            this.mAuthority = authority;
            this.mPath = path;
            this.mHttpEnabled = httpEnabled;
            this.mHandler = handler;
        }

        @WorkerThread
        @Nullable
        public PathHandler match(@NonNull Uri uri) {
            if (uri.getScheme().equals(HTTP_SCHEME) && !this.mHttpEnabled) {
                return null;
            }
            if (!uri.getScheme().equals(HTTP_SCHEME) && !uri.getScheme().equals(HTTPS_SCHEME)) {
                return null;
            }
            if (!uri.getAuthority().equals(this.mAuthority)) {
                return null;
            }
            if (!uri.getPath().startsWith(this.mPath)) {
                return null;
            }
            return this.mHandler;
        }

        @WorkerThread
        @NonNull
        public String getSuffixPath(@NonNull String path) {
            return path.replaceFirst(this.mPath, "");
        }
    }

    public static interface PathHandler {
        @WorkerThread
        @Nullable
        public WebResourceResponse handle(@NonNull String var1);
    }

    public static final class Builder {
        private boolean mHttpAllowed;
        private String mDomain = "appassets.androidplatform.net";
        @NonNull
        private final List<Pair<String, PathHandler>> mHandlerList = new ArrayList<Pair<String, PathHandler>>();

        @NonNull
        public Builder setDomain(@NonNull String domain) {
            this.mDomain = domain;
            return this;
        }

        @NonNull
        public Builder setHttpAllowed(boolean httpAllowed) {
            this.mHttpAllowed = httpAllowed;
            return this;
        }

        @NonNull
        public Builder addPathHandler(@NonNull String path, @NonNull PathHandler handler) {
            this.mHandlerList.add((Pair<String, PathHandler>)Pair.create((Object)path, (Object)handler));
            return this;
        }

        @NonNull
        public WebViewAssetLoader build() {
            ArrayList<PathMatcher> pathMatcherList = new ArrayList<PathMatcher>();
            for (Pair<String, PathHandler> pair : this.mHandlerList) {
                String path = (String)pair.first;
                PathHandler handler = (PathHandler)pair.second;
                pathMatcherList.add(new PathMatcher(this.mDomain, path, this.mHttpAllowed, handler));
            }
            return new WebViewAssetLoader(pathMatcherList);
        }
    }

    public static final class InternalStoragePathHandler
    implements PathHandler {
        private static final String[] FORBIDDEN_DATA_DIRS = new String[]{"app_webview/", "databases/", "lib/", "shared_prefs/", "code_cache/"};
        @NonNull
        private final File mDirectory;

        public InternalStoragePathHandler(@NonNull Context context, @NonNull File directory) {
            try {
                this.mDirectory = new File(AssetHelper.getCanonicalDirPath(directory));
                if (!this.isAllowedInternalStorageDir(context)) {
                    throw new IllegalArgumentException("The given directory \"" + directory + "\" doesn't exist under an allowed app internal storage directory");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to resolve the canonical path for the given directory: " + directory.getPath(), e);
            }
        }

        private boolean isAllowedInternalStorageDir(@NonNull Context context) throws IOException {
            String dir = AssetHelper.getCanonicalDirPath(this.mDirectory);
            String cacheDir = AssetHelper.getCanonicalDirPath(context.getCacheDir());
            String dataDir = AssetHelper.getCanonicalDirPath(AssetHelper.getDataDir(context));
            if (!dir.startsWith(cacheDir) && !dir.startsWith(dataDir)) {
                return false;
            }
            if (dir.equals(cacheDir) || dir.equals(dataDir)) {
                return false;
            }
            for (String forbiddenPath : FORBIDDEN_DATA_DIRS) {
                if (!dir.startsWith(dataDir + forbiddenPath)) continue;
                return false;
            }
            return true;
        }

        @Override
        @WorkerThread
        @NonNull
        public WebResourceResponse handle(@NonNull String path) {
            try {
                File file = AssetHelper.getCanonicalFileIfChild(this.mDirectory, path);
                if (file != null) {
                    InputStream is = AssetHelper.openFile(file);
                    String mimeType = AssetHelper.guessMimeType(path);
                    return new WebResourceResponse(mimeType, null, is);
                }
                Log.e((String)WebViewAssetLoader.TAG, (String)String.format("The requested file: %s is outside the mounted directory: %s", path, this.mDirectory));
            }
            catch (IOException e) {
                Log.e((String)WebViewAssetLoader.TAG, (String)("Error opening the requested path: " + path), (Throwable)e);
            }
            return new WebResourceResponse(null, null, null);
        }
    }

    public static final class ResourcesPathHandler
    implements PathHandler {
        private AssetHelper mAssetHelper;

        public ResourcesPathHandler(@NonNull Context context) {
            this.mAssetHelper = new AssetHelper(context);
        }

        @VisibleForTesting
        ResourcesPathHandler(@NonNull AssetHelper assetHelper) {
            this.mAssetHelper = assetHelper;
        }

        @Override
        @WorkerThread
        @Nullable
        public WebResourceResponse handle(@NonNull String path) {
            try {
                InputStream is = this.mAssetHelper.openResource(path);
                String mimeType = AssetHelper.guessMimeType(path);
                return new WebResourceResponse(mimeType, null, is);
            }
            catch (Resources.NotFoundException e) {
                Log.e((String)WebViewAssetLoader.TAG, (String)("Resource not found from the path: " + path), (Throwable)e);
            }
            catch (IOException e) {
                Log.e((String)WebViewAssetLoader.TAG, (String)("Error opening resource from the path: " + path), (Throwable)e);
            }
            return new WebResourceResponse(null, null, null);
        }
    }

    public static final class AssetsPathHandler
    implements PathHandler {
        private AssetHelper mAssetHelper;

        public AssetsPathHandler(@NonNull Context context) {
            this.mAssetHelper = new AssetHelper(context);
        }

        @VisibleForTesting
        AssetsPathHandler(@NonNull AssetHelper assetHelper) {
            this.mAssetHelper = assetHelper;
        }

        @Override
        @WorkerThread
        @Nullable
        public WebResourceResponse handle(@NonNull String path) {
            try {
                InputStream is = this.mAssetHelper.openAsset(path);
                String mimeType = AssetHelper.guessMimeType(path);
                return new WebResourceResponse(mimeType, null, is);
            }
            catch (IOException e) {
                Log.e((String)WebViewAssetLoader.TAG, (String)("Error opening asset path: " + path), (Throwable)e);
                return new WebResourceResponse(null, null, null);
            }
        }
    }
}

