/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.os.Handler;
import android.webkit.WebMessage;
import android.webkit.WebMessagePort;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.webkit.WebMessageCompat;
import androidx.webkit.WebMessagePortCompat;
import androidx.webkit.internal.ApiFeature;
import androidx.webkit.internal.ApiHelperForM;
import androidx.webkit.internal.WebMessageAdapter;
import androidx.webkit.internal.WebMessageCallbackAdapter;
import androidx.webkit.internal.WebViewFeatureInternal;
import androidx.webkit.internal.WebViewGlueCommunicator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.chromium.support_lib_boundary.WebMessagePortBoundaryInterface;
import org.chromium.support_lib_boundary.util.BoundaryInterfaceReflectionUtil;

public class WebMessagePortImpl
extends WebMessagePortCompat {
    private WebMessagePort mFrameworksImpl;
    private WebMessagePortBoundaryInterface mBoundaryInterface;

    public WebMessagePortImpl(@NonNull WebMessagePort frameworksImpl) {
        this.mFrameworksImpl = frameworksImpl;
    }

    public WebMessagePortImpl(@NonNull InvocationHandler invocationHandler) {
        this.mBoundaryInterface = BoundaryInterfaceReflectionUtil.castToSuppLibClass(WebMessagePortBoundaryInterface.class, invocationHandler);
    }

    @RequiresApi(value=23)
    private WebMessagePort getFrameworksImpl() {
        if (this.mFrameworksImpl == null) {
            this.mFrameworksImpl = WebViewGlueCommunicator.getCompatConverter().convertWebMessagePort(Proxy.getInvocationHandler(this.mBoundaryInterface));
        }
        return this.mFrameworksImpl;
    }

    private WebMessagePortBoundaryInterface getBoundaryInterface() {
        if (this.mBoundaryInterface == null) {
            this.mBoundaryInterface = BoundaryInterfaceReflectionUtil.castToSuppLibClass(WebMessagePortBoundaryInterface.class, WebViewGlueCommunicator.getCompatConverter().convertWebMessagePort(this.mFrameworksImpl));
        }
        return this.mBoundaryInterface;
    }

    @Override
    public void postMessage(@NonNull WebMessageCompat message) {
        ApiFeature.M feature = WebViewFeatureInternal.WEB_MESSAGE_PORT_POST_MESSAGE;
        if (feature.isSupportedByFramework() && message.getType() == 0) {
            ApiHelperForM.postMessage(this.getFrameworksImpl(), WebMessagePortImpl.compatToFrameworkMessage(message));
        } else if (feature.isSupportedByWebView() && WebMessageAdapter.isMessagePayloadTypeSupportedByWebView(message.getType())) {
            this.getBoundaryInterface().postMessage(BoundaryInterfaceReflectionUtil.createInvocationHandlerFor(new WebMessageAdapter(message)));
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public void close() {
        ApiFeature.M feature = WebViewFeatureInternal.WEB_MESSAGE_PORT_CLOSE;
        if (feature.isSupportedByFramework()) {
            ApiHelperForM.close(this.getFrameworksImpl());
        } else if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().close();
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public void setWebMessageCallback(@NonNull WebMessagePortCompat.WebMessageCallbackCompat callback) {
        ApiFeature.M feature = WebViewFeatureInternal.WEB_MESSAGE_PORT_SET_MESSAGE_CALLBACK;
        if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().setWebMessageCallback(BoundaryInterfaceReflectionUtil.createInvocationHandlerFor(new WebMessageCallbackAdapter(callback)));
        } else if (feature.isSupportedByFramework()) {
            ApiHelperForM.setWebMessageCallback(this.getFrameworksImpl(), callback);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    public void setWebMessageCallback(@Nullable Handler handler, @NonNull WebMessagePortCompat.WebMessageCallbackCompat callback) {
        ApiFeature.M feature = WebViewFeatureInternal.CREATE_WEB_MESSAGE_CHANNEL;
        if (feature.isSupportedByWebView()) {
            this.getBoundaryInterface().setWebMessageCallback(BoundaryInterfaceReflectionUtil.createInvocationHandlerFor(new WebMessageCallbackAdapter(callback)), handler);
        } else if (feature.isSupportedByFramework()) {
            ApiHelperForM.setWebMessageCallback(this.getFrameworksImpl(), callback, handler);
        } else {
            throw WebViewFeatureInternal.getUnsupportedOperationException();
        }
    }

    @Override
    @NonNull
    @RequiresApi(value=23)
    public WebMessagePort getFrameworkPort() {
        return this.getFrameworksImpl();
    }

    @Override
    @NonNull
    public InvocationHandler getInvocationHandler() {
        return Proxy.getInvocationHandler(this.getBoundaryInterface());
    }

    @Nullable
    public static WebMessagePortCompat[] portsToCompat(@Nullable WebMessagePort[] ports) {
        if (ports == null) {
            return null;
        }
        WebMessagePortCompat[] compatPorts = new WebMessagePortCompat[ports.length];
        for (int n = 0; n < ports.length; ++n) {
            compatPorts[n] = new WebMessagePortImpl(ports[n]);
        }
        return compatPorts;
    }

    @RequiresApi(value=23)
    @Nullable
    public static WebMessagePort[] compatToPorts(@Nullable WebMessagePortCompat[] compatPorts) {
        if (compatPorts == null) {
            return null;
        }
        WebMessagePort[] ports = new WebMessagePort[compatPorts.length];
        for (int n = 0; n < ports.length; ++n) {
            ports[n] = compatPorts[n].getFrameworkPort();
        }
        return ports;
    }

    @RequiresApi(value=23)
    @NonNull
    public static WebMessage compatToFrameworkMessage(@NonNull WebMessageCompat message) {
        return ApiHelperForM.createWebMessage(message);
    }

    @RequiresApi(value=23)
    @NonNull
    public static WebMessageCompat frameworkMessageToCompat(@NonNull WebMessage message) {
        return ApiHelperForM.createWebMessageCompat(message);
    }
}

