/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.webkit.CookieManager;
import android.webkit.SafeBrowsingResponse;
import android.webkit.ServiceWorkerWebSettings;
import android.webkit.WebMessagePort;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.webkit.internal.CookieManagerAdapter;
import androidx.webkit.internal.WebResourceRequestAdapter;
import androidx.webkit.internal.WebSettingsAdapter;
import java.lang.reflect.InvocationHandler;
import org.chromium.support_lib_boundary.WebResourceRequestBoundaryInterface;
import org.chromium.support_lib_boundary.WebSettingsBoundaryInterface;
import org.chromium.support_lib_boundary.WebViewCookieManagerBoundaryInterface;
import org.chromium.support_lib_boundary.WebkitToCompatConverterBoundaryInterface;
import org.chromium.support_lib_boundary.util.BoundaryInterfaceReflectionUtil;

public class WebkitToCompatConverter {
    private final WebkitToCompatConverterBoundaryInterface mImpl;

    public WebkitToCompatConverter(@NonNull WebkitToCompatConverterBoundaryInterface impl) {
        this.mImpl = impl;
    }

    @NonNull
    public WebSettingsAdapter convertSettings(@NonNull WebSettings webSettings) {
        return new WebSettingsAdapter(BoundaryInterfaceReflectionUtil.castToSuppLibClass(WebSettingsBoundaryInterface.class, this.mImpl.convertSettings(webSettings)));
    }

    @NonNull
    public WebResourceRequestAdapter convertWebResourceRequest(@NonNull WebResourceRequest request) {
        return new WebResourceRequestAdapter(BoundaryInterfaceReflectionUtil.castToSuppLibClass(WebResourceRequestBoundaryInterface.class, this.mImpl.convertWebResourceRequest(request)));
    }

    @NonNull
    public InvocationHandler convertServiceWorkerSettings(@NonNull ServiceWorkerWebSettings settings) {
        return this.mImpl.convertServiceWorkerSettings(settings);
    }

    @RequiresApi(value=24)
    @NonNull
    public ServiceWorkerWebSettings convertServiceWorkerSettings(@NonNull InvocationHandler serviceWorkerSettings) {
        return (ServiceWorkerWebSettings)this.mImpl.convertServiceWorkerSettings(serviceWorkerSettings);
    }

    @NonNull
    public InvocationHandler convertWebResourceError(@NonNull WebResourceError webResourceError) {
        return this.mImpl.convertWebResourceError(webResourceError);
    }

    @RequiresApi(value=23)
    @NonNull
    public WebResourceError convertWebResourceError(@NonNull InvocationHandler webResourceError) {
        return (WebResourceError)this.mImpl.convertWebResourceError(webResourceError);
    }

    @NonNull
    public InvocationHandler convertSafeBrowsingResponse(@NonNull SafeBrowsingResponse safeBrowsingResponse) {
        return this.mImpl.convertSafeBrowsingResponse(safeBrowsingResponse);
    }

    @RequiresApi(value=27)
    @NonNull
    public SafeBrowsingResponse convertSafeBrowsingResponse(@NonNull InvocationHandler safeBrowsingResponse) {
        return (SafeBrowsingResponse)this.mImpl.convertSafeBrowsingResponse(safeBrowsingResponse);
    }

    @NonNull
    public InvocationHandler convertWebMessagePort(@NonNull WebMessagePort webMessagePort) {
        return this.mImpl.convertWebMessagePort(webMessagePort);
    }

    @RequiresApi(value=23)
    @NonNull
    public WebMessagePort convertWebMessagePort(@NonNull InvocationHandler webMessagePort) {
        return (WebMessagePort)this.mImpl.convertWebMessagePort(webMessagePort);
    }

    @NonNull
    public CookieManagerAdapter convertCookieManager(@NonNull CookieManager cookieManager) {
        return new CookieManagerAdapter(BoundaryInterfaceReflectionUtil.castToSuppLibClass(WebViewCookieManagerBoundaryInterface.class, this.mImpl.convertCookieManager(cookieManager)));
    }
}

