/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.support_lib_boundary.util;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;

public class BoundaryInterfaceReflectionUtil {
    public static boolean instanceOfInOwnClassLoader(Object obj, String className) {
        try {
            ClassLoader loader = obj.getClass().getClassLoader();
            Class<?> clazz = Class.forName(className, false, loader);
            return clazz.isInstance(obj);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Method dupeMethod(Method method, ClassLoader delegateLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> declaringClass = Class.forName(method.getDeclaringClass().getName(), true, delegateLoader);
        Class<?>[] parameterClasses = method.getParameterTypes();
        return declaringClass.getDeclaredMethod(method.getName(), parameterClasses);
    }

    @Nullable
    public static <T> T castToSuppLibClass(@NonNull Class<T> clazz, @Nullable InvocationHandler invocationHandler) {
        if (invocationHandler == null) {
            return null;
        }
        return clazz.cast(Proxy.newProxyInstance(BoundaryInterfaceReflectionUtil.class.getClassLoader(), new Class[]{clazz}, invocationHandler));
    }

    @RequiresApi(value=19)
    @Nullable
    public static InvocationHandler createInvocationHandlerFor(@Nullable Object delegate) {
        if (delegate == null) {
            return null;
        }
        return new InvocationHandlerWithDelegateGetter(delegate);
    }

    @RequiresApi(value=19)
    @Nullable
    public static InvocationHandler[] createInvocationHandlersForArray(@Nullable Object[] delegates) {
        if (delegates == null) {
            return null;
        }
        InvocationHandler[] handlers = new InvocationHandler[delegates.length];
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i] = BoundaryInterfaceReflectionUtil.createInvocationHandlerFor(delegates[i]);
        }
        return handlers;
    }

    @RequiresApi(value=19)
    @Nullable
    public static Object getDelegateFromInvocationHandler(@Nullable InvocationHandler invocationHandler) {
        if (invocationHandler == null) {
            return null;
        }
        InvocationHandlerWithDelegateGetter objectHolder = (InvocationHandlerWithDelegateGetter)invocationHandler;
        return objectHolder.getDelegate();
    }

    private static boolean isDebuggable() {
        return "eng".equals(Build.TYPE) || "userdebug".equals(Build.TYPE);
    }

    public static boolean containsFeature(Collection<String> features, String soughtFeature) {
        assert (!soughtFeature.endsWith(":dev"));
        return features.contains(soughtFeature) || BoundaryInterfaceReflectionUtil.isDebuggable() && features.contains(soughtFeature + ":dev");
    }

    public static boolean containsFeature(String[] features, String soughtFeature) {
        return BoundaryInterfaceReflectionUtil.containsFeature(Arrays.asList(features), soughtFeature);
    }

    @RequiresApi(value=19)
    private static class InvocationHandlerWithDelegateGetter
    implements InvocationHandler {
        private final Object mDelegate;

        public InvocationHandlerWithDelegateGetter(@NonNull Object delegate) {
            this.mDelegate = delegate;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            ClassLoader delegateLoader = this.mDelegate.getClass().getClassLoader();
            try {
                return BoundaryInterfaceReflectionUtil.dupeMethod(method, delegateLoader).invoke(this.mDelegate, objects);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Reflection failed for method " + method, e);
            }
        }

        @NonNull
        public Object getDelegate() {
            return this.mDelegate;
        }
    }
}

