/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.Image;
import android.net.Uri;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_vision_common.zzms;
import com.google.android.gms.internal.mlkit_vision_common.zzmu;
import com.google.mlkit.common.sdkinternal.MLTaskInput;
import com.google.mlkit.vision.common.internal.ImageConvertUtils;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.common.zzb;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.Immutable;

@Immutable
public class InputImage
implements MLTaskInput {
    public static final int IMAGE_FORMAT_NV21 = 17;
    public static final int IMAGE_FORMAT_YV12 = 842094169;
    @KeepForSdk
    public static final int IMAGE_FORMAT_BITMAP = -1;
    public static final int IMAGE_FORMAT_YUV_420_888 = 35;
    @Nullable
    private volatile Bitmap zza;
    @Nullable
    private volatile ByteBuffer zzb;
    @Nullable
    private volatile zzb zzc;
    private final int zzd;
    private final int zze;
    private final int zzf;
    @ImageFormat
    private final int zzg;
    @Nullable
    private final Matrix zzh;

    @KeepForSdk
    @ImageFormat
    public int getFormat() {
        return this.zzg;
    }

    @KeepForSdk
    public int getHeight() {
        return this.zze;
    }

    @KeepForSdk
    public int getRotationDegrees() {
        return this.zzf;
    }

    @KeepForSdk
    public int getWidth() {
        return this.zzd;
    }

    @KeepForSdk
    @Nullable
    public Bitmap getBitmapInternal() {
        return this.zza;
    }

    @KeepForSdk
    @Nullable
    public Matrix getCoordinatesMatrix() {
        return this.zzh;
    }

    @KeepForSdk
    @Nullable
    public Image getMediaImage() {
        if (this.zzc == null) {
            return null;
        }
        return this.zzc.zza();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static InputImage fromBitmap(@NonNull Bitmap bitmap, int rotationDegrees) {
        void var1_1;
        Bitmap bitmap2;
        InputImage inputImage = new InputImage(bitmap2, (int)var1_1);
        InputImage.zzc(-1, 1, SystemClock.elapsedRealtime(), bitmap2.getHeight(), bitmap2.getWidth(), bitmap2.getAllocationByteCount(), (int)var1_1);
        return inputImage;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static InputImage fromByteArray(@NonNull byte[] byteArray, int width, int height, int rotationDegrees, @ImageFormat int format) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        InputImage inputImage = new InputImage(ByteBuffer.wrap((byte[])Preconditions.checkNotNull((Object)byArray)), (int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
        InputImage.zzc(format, 2, SystemClock.elapsedRealtime(), (int)var2_2, (int)var1_1, byArray.length, (int)var3_3);
        return inputImage;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static InputImage fromByteBuffer(@NonNull ByteBuffer byteBuffer, int width, int height, int rotationDegrees, @ImageFormat int format) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer2;
        InputImage inputImage = new InputImage(byteBuffer2, (int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
        InputImage.zzc(format, 3, SystemClock.elapsedRealtime(), (int)var2_2, (int)var1_1, byteBuffer2.limit(), (int)var3_3);
        return inputImage;
    }

    @NonNull
    public static InputImage fromFilePath(@NonNull Context context, @NonNull Uri imageUri) throws IOException {
        Context context2;
        InputImage inputImage;
        Preconditions.checkNotNull((Object)context, (Object)"Please provide a valid Context");
        Preconditions.checkNotNull((Object)inputImage, (Object)"Please provide a valid imageUri");
        context2 = ImageUtils.getInstance().zza(context2.getContentResolver(), (Uri)inputImage);
        inputImage = new InputImage((Bitmap)context2, 0);
        InputImage.zzc(-1, 4, SystemClock.elapsedRealtime(), context2.getHeight(), context2.getWidth(), context2.getAllocationByteCount(), 0);
        return inputImage;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static InputImage fromMediaImage(@NonNull Image image, int rotationDegrees) {
        void var1_1;
        return InputImage.zzb(image, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static InputImage fromMediaImage(@NonNull Image image, int rotationDegrees, @NonNull Matrix coordinatesMatrix) {
        void var2_2;
        void var1_1;
        Image image2;
        boolean bl = image.getFormat() == 35;
        Preconditions.checkArgument((boolean)bl, (Object)"Only YUV_420_888 is supported now");
        return InputImage.zzb(image2, (int)var1_1, (Matrix)var2_2);
    }

    @KeepForSdk
    @Nullable
    public ByteBuffer getByteBuffer() {
        return this.zzb;
    }

    private InputImage(@NonNull Bitmap bitmap, int n) {
        this.zza = (Bitmap)Preconditions.checkNotNull((Object)bitmap);
        this.zzd = bitmap.getWidth();
        this.zze = bitmap.getHeight();
        InputImage.zza(n);
        this.zzf = n;
        this.zzg = -1;
        this.zzh = null;
    }

    private InputImage(@NonNull Image image, int n, int n2, int n3, @Nullable Matrix matrix) {
        Preconditions.checkNotNull((Object)image);
        this.zzc = new zzb(image);
        this.zzd = n;
        this.zze = n2;
        InputImage.zza(n3);
        this.zzf = n3;
        this.zzg = 35;
        this.zzh = matrix;
    }

    /*
     * Enabled aggressive block sorting
     */
    private InputImage(@NonNull ByteBuffer byteBuffer, int n, int n2, int n3, @ImageFormat int n4) {
        boolean bl;
        if (n4 != 842094169) {
            if (n4 == 17) {
                n4 = 17;
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = true;
        }
        Preconditions.checkArgument((boolean)bl);
        this.zzb = (ByteBuffer)Preconditions.checkNotNull((Object)byteBuffer);
        bl = byteBuffer.limit() > n * n2;
        Preconditions.checkArgument((boolean)bl, (Object)"Image dimension, ByteBuffer size and format don't match. Please check if the ByteBuffer is in the decalred format.");
        byteBuffer.rewind();
        this.zzd = n;
        this.zze = n2;
        InputImage.zza(n3);
        this.zzf = n3;
        this.zzg = n4;
        this.zzh = null;
    }

    @KeepForSdk
    @Nullable
    public Image.Plane[] getPlanes() {
        if (this.zzc == null) {
            return null;
        }
        return this.zzc.zzb();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int zza(int n) {
        boolean bl;
        block4: {
            block5: {
                block6: {
                    if (n == 0) break block5;
                    if (n == 90) break block6;
                    if (n != 180) {
                        if (n == 270) {
                            n = 270;
                            bl = true;
                            break block4;
                        } else {
                            bl = false;
                        }
                        break block4;
                    } else {
                        bl = true;
                    }
                    break block4;
                }
                bl = true;
                break block4;
            }
            bl = true;
        }
        Preconditions.checkArgument((boolean)bl, (Object)"Invalid rotation. Only 0, 90, 180, 270 are supported currently.");
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static InputImage zzb(@NonNull Image image, int n, @Nullable Matrix object) {
        void var2_4;
        long l = SystemClock.elapsedRealtime();
        Preconditions.checkNotNull((Object)image, (Object)"Please provide a valid image");
        InputImage.zza(n);
        int n2 = image.getFormat() != 256 ? (image.getFormat() == 35 ? 1 : 0) : 1;
        Preconditions.checkArgument(n2 != 0, (Object)"Only JPEG and YUV_420_888 are supported now");
        Image.Plane[] planeArray = image.getPlanes();
        if (image.getFormat() == 256) {
            InputImage inputImage = new InputImage(ImageConvertUtils.getInstance().convertJpegToUpRightBitmap(image, n), 0);
            n2 = image.getPlanes()[0].getBuffer().limit();
        } else {
            InputImage inputImage;
            for (Image.Plane plane : planeArray) {
                if (plane.getBuffer() == null) continue;
                plane.getBuffer().rewind();
            }
            Image image2 = image;
            InputImage inputImage2 = inputImage = new InputImage(image2, image.getWidth(), image2.getHeight(), n, (Matrix)object);
            n2 = image.getPlanes()[0].getBuffer().limit() * 3 / 2;
        }
        InputImage.zzc(image.getFormat(), 5, l, image.getHeight(), image.getWidth(), n2, n);
        return var2_4;
    }

    private static void zzc(int n, int n2, long l, int n3, int n4, int n5, int n6) {
        zzmu.zza(zzms.zzb("vision-common"), n, n2, l, n3, n4, n5, n6);
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ImageFormat {
    }
}

