/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import com.google.common.base.Joiner;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.launcher.daemon.diagnostics.DaemonStartupInfo;

public class DaemonGreeter {
    private final DocumentationRegistry documentationRegistry;

    public DaemonGreeter(DocumentationRegistry documentationRegistry) {
        this.documentationRegistry = documentationRegistry;
    }

    public DaemonStartupInfo parseDaemonOutput(String output, List<String> startupArgs) {
        DaemonStartupCommunication startupCommunication = new DaemonStartupCommunication();
        if (!startupCommunication.containsGreeting(output)) {
            throw new GradleException(this.prepareMessage(output, startupArgs));
        }
        String[] lines = output.split("\n");
        String lastLine = lines[lines.length - 1];
        return startupCommunication.readDiagnostics(lastLine);
    }

    private String prepareMessage(String output, List<String> startupArgs) {
        return "Unable to start the daemon process.\nThis problem might be caused by incorrect configuration of the daemon.\nFor example, an unrecognized jvm option is used." + this.documentationRegistry.getDocumentationRecommendationFor("details on the daemon", "gradle_daemon") + "\nProcess command line: " + Joiner.on((String)" ").join(startupArgs) + "\nPlease read the following process output to find out more:\n-----------------------\n" + output;
    }
}

