/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.BuildController;
import org.gradle.execution.EntryTaskSelector;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.TaskNodeFactory;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildWorkGraph;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.ExportedTaskNode;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultBuildController
implements BuildController {
    private final BuildWorkGraph workGraph;
    private final Set<ExportedTaskNode> scheduled = new LinkedHashSet<ExportedTaskNode>();
    private final Set<ExportedTaskNode> queuedForExecution = new LinkedHashSet<ExportedTaskNode>();
    private final WorkerLeaseService workerLeaseService;
    private State state = State.DiscoveringTasks;

    public DefaultBuildController(BuildState build, WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
        this.workGraph = build.getWorkGraph().newWorkGraph();
    }

    public void queueForExecution(ExportedTaskNode taskNode) {
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.add(taskNode);
    }

    public void populateWorkGraph(Consumer<? super BuildLifecycleController.WorkGraphBuilder> action) {
        this.assertInState(State.DiscoveringTasks);
        this.workGraph.populateWorkGraph(action);
    }

    public void addFilter(Spec<Task> filter) {
        this.assertInState(State.DiscoveringTasks);
        this.workGraph.addFilter(filter);
    }

    public void addFinalization(BiConsumer<EntryTaskSelector.Context, QueryableExecutionPlan> finalization) {
        this.assertInState(State.DiscoveringTasks);
        this.workGraph.addFinalization(finalization);
    }

    public boolean scheduleQueuedTasks() {
        this.assertInState(State.DiscoveringTasks);
        this.queuedForExecution.removeAll(this.scheduled);
        if (this.queuedForExecution.isEmpty()) {
            return false;
        }
        boolean added = this.workGraph.schedule(this.queuedForExecution);
        this.scheduled.addAll(this.queuedForExecution);
        this.queuedForExecution.clear();
        return added;
    }

    public void finalizeWorkGraph() {
        this.assertInState(State.DiscoveringTasks);
        if (!this.queuedForExecution.isEmpty()) {
            throw new IllegalStateException("Queued tasks have not been scheduled.");
        }
        HashSet<TaskInternal> visited = new HashSet<TaskInternal>();
        HashSet<TaskInternal> visiting = new HashSet<TaskInternal>();
        for (ExportedTaskNode node : this.scheduled) {
            this.checkForCyclesFor(node.getTask(), visited, visiting);
        }
        this.workGraph.finalizeGraph();
        this.state = State.ReadyToRun;
    }

    public void startExecution(ExecutorService executorService, Consumer<ExecutionResult<Void>> completionHandler) {
        this.assertInState(State.ReadyToRun);
        executorService.submit(new BuildOpRunnable(CurrentBuildOperationRef.instance().get(), completionHandler));
        this.state = State.RunningTasks;
    }

    public void stop() {
        this.workGraph.stop();
    }

    private void assertInState(State expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Build is in unexpected state: " + (Object)((Object)this.state));
        }
    }

    private void checkForCyclesFor(TaskInternal task, Set<TaskInternal> visited, Set<TaskInternal> visiting) {
        if (visited.contains(task)) {
            return;
        }
        if (!visiting.add(task)) {
            CachingDirectedGraphWalker graphWalker = new CachingDirectedGraphWalker((node, values, connectedNodes) -> this.visitDependenciesOf((TaskInternal)node, connectedNodes::add));
            graphWalker.add((Object[])new TaskInternal[]{task});
            List cycles = graphWalker.findCycles();
            Set cycle = (Set)cycles.get(0);
            DirectedGraphRenderer graphRenderer = new DirectedGraphRenderer((node, output) -> output.withStyle(StyledTextOutput.Style.Identifier).text((Object)node.getIdentityPath()), (node, values, connectedNodes) -> this.visitDependenciesOf((TaskInternal)node, dep -> {
                if (cycle.contains(dep)) {
                    connectedNodes.add(dep);
                }
            }));
            StringWriter writer = new StringWriter();
            graphRenderer.renderTo((Object)task, (Appendable)writer);
            throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer));
        }
        this.visitDependenciesOf(task, dep -> this.checkForCyclesFor((TaskInternal)dep, visited, visiting));
        visiting.remove(task);
        visited.add(task);
    }

    private void visitDependenciesOf(TaskInternal task, Consumer<TaskInternal> consumer) {
        TaskNodeFactory taskNodeFactory = (TaskNodeFactory)((GradleInternal)task.getProject().getGradle()).getServices().get(TaskNodeFactory.class);
        TaskNode node = taskNodeFactory.getOrCreateNode((Task)task);
        for (Node dependency : node.getAllSuccessors()) {
            if (!(dependency instanceof TaskNode)) continue;
            consumer.accept(((TaskNode)dependency).getTask());
        }
    }

    private ExecutionResult<Void> doRun() {
        try {
            return (ExecutionResult)this.workerLeaseService.runAsWorkerThread(() -> ((BuildWorkGraph)this.workGraph).runWork());
        }
        catch (Throwable t) {
            return ExecutionResult.failed((Throwable)t);
        }
    }

    private class BuildOpRunnable
    implements Runnable {
        private final BuildOperationRef parentBuildOperation;
        private final Consumer<ExecutionResult<Void>> completionHandler;

        BuildOpRunnable(BuildOperationRef parentBuildOperation, Consumer<ExecutionResult<Void>> completionHandler) {
            this.parentBuildOperation = parentBuildOperation;
            this.completionHandler = completionHandler;
        }

        @Override
        public void run() {
            CurrentBuildOperationRef.instance().set(this.parentBuildOperation);
            try {
                this.completionHandler.accept((ExecutionResult<Void>)DefaultBuildController.this.doRun());
            }
            finally {
                CurrentBuildOperationRef.instance().set(null);
            }
        }
    }

    private static enum State {
        DiscoveringTasks,
        ReadyToRun,
        RunningTasks,
        Finished;

    }
}

