/*
 * Decompiled with CFR 0.152.
 */
package io.capawesome.capacitorjs.plugins.mlkit.barcodescanning;

import android.graphics.Point;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.google.mlkit.vision.barcode.common.Barcode;
import org.json.JSONArray;
import org.json.JSONException;

public class BarcodeScannerHelper {
    public static JSObject createBarcodeResultForBarcode(@NonNull Barcode barcode, @Nullable Point imageSize, @Nullable Point screenSize) {
        Point[] cornerPoints = barcode.getCornerPoints();
        JSArray cornerPointsResult = new JSArray();
        if (cornerPoints != null && imageSize != null && screenSize != null) {
            Point[] normalizedCornerPoints = BarcodeScannerHelper.normalizeCornerPoints(cornerPoints, imageSize, screenSize);
            for (int i = 0; i < normalizedCornerPoints.length; ++i) {
                JSArray cornerPointResult = new JSArray();
                cornerPointResult.put(normalizedCornerPoints[i].x);
                cornerPointResult.put(normalizedCornerPoints[i].y);
                cornerPointsResult.put((Object)cornerPointResult);
            }
        }
        JSObject result = new JSObject();
        result.put("bytes", (Object)BarcodeScannerHelper.convertByteArrayToJsonArray(barcode.getRawBytes()));
        if (cornerPoints != null) {
            result.put("cornerPoints", (Object)cornerPointsResult);
        }
        result.put("displayValue", barcode.getDisplayValue());
        result.put("format", BarcodeScannerHelper.convertBarcodeScannerFormatToString(barcode.getFormat()));
        result.put("rawValue", barcode.getRawValue());
        result.put("valueType", BarcodeScannerHelper.convertBarcodeValueTypeToString(barcode.getValueType()));
        return result;
    }

    public static int[] convertStringsToBarcodeScannerFormats(String[] values) throws JSONException {
        int[] formats = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer format = BarcodeScannerHelper.convertStringToBarcodeScannerFormat(values[i]);
            if (format == null) continue;
            formats[i] = format;
        }
        return formats;
    }

    @Nullable
    public static Integer convertStringToBarcodeScannerFormat(String value) {
        switch (value) {
            case "AZTEC": {
                return 4096;
            }
            case "CODABAR": {
                return 8;
            }
            case "CODE_39": {
                return 2;
            }
            case "CODE_93": {
                return 4;
            }
            case "CODE_128": {
                return 1;
            }
            case "DATA_MATRIX": {
                return 16;
            }
            case "EAN_8": {
                return 64;
            }
            case "EAN_13": {
                return 32;
            }
            case "ITF": {
                return 128;
            }
            case "PDF_417": {
                return 2048;
            }
            case "QR_CODE": {
                return 256;
            }
            case "UPC_A": {
                return 512;
            }
            case "UPC_E": {
                return 1024;
            }
        }
        return null;
    }

    @Nullable
    public static String convertBarcodeScannerFormatToString(int format) {
        switch (format) {
            case 4096: {
                return "AZTEC";
            }
            case 8: {
                return "CODABAR";
            }
            case 2: {
                return "CODE_39";
            }
            case 4: {
                return "CODE_93";
            }
            case 1: {
                return "CODE_128";
            }
            case 16: {
                return "DATA_MATRIX";
            }
            case 64: {
                return "EAN_8";
            }
            case 32: {
                return "EAN_13";
            }
            case 128: {
                return "ITF";
            }
            case 2048: {
                return "PDF_417";
            }
            case 256: {
                return "QR_CODE";
            }
            case 512: {
                return "UPC_A";
            }
            case 1024: {
                return "UPC_E";
            }
        }
        return null;
    }

    @Nullable
    public static String convertBarcodeValueTypeToString(int format) {
        switch (format) {
            case 11: {
                return "CALENDAR_EVENT";
            }
            case 1: {
                return "CONTACT_INFO";
            }
            case 12: {
                return "DRIVERS_LICENSE";
            }
            case 2: {
                return "EMAIL";
            }
            case 10: {
                return "GEO";
            }
            case 3: {
                return "ISBN";
            }
            case 4: {
                return "PHONE";
            }
            case 5: {
                return "PRODUCT";
            }
            case 6: {
                return "SMS";
            }
            case 7: {
                return "TEXT";
            }
            case 8: {
                return "URL";
            }
            case 9: {
                return "WIFI";
            }
        }
        return "UNKNOWN";
    }

    private static JSONArray convertByteArrayToJsonArray(byte[] bytes) {
        JSONArray ret = new JSONArray();
        for (byte _byte : bytes) {
            ret.put((int)_byte);
        }
        return ret;
    }

    private static Point[] normalizeCornerPoints(@NonNull Point[] cornerPoints, @NonNull Point imageSize, @NonNull Point screenSize) {
        double screenWidth = screenSize.x;
        double screenHeight = screenSize.y;
        double imageWidth = imageSize.x;
        double imageHeight = imageSize.y;
        if (screenWidth > screenHeight) {
            imageWidth = imageSize.y;
            imageHeight = imageSize.x;
        }
        double scale = Math.max(screenHeight / imageWidth, screenWidth / imageHeight);
        double invisibleWidth = imageHeight * scale - screenWidth;
        double invisibleHeight = imageWidth * scale - screenHeight;
        Point[] normalizedCornerPoints = new Point[cornerPoints.length];
        for (int i = 0; i < cornerPoints.length; ++i) {
            int x = (int)((double)cornerPoints[i].x * scale - invisibleWidth / 2.0);
            int y = (int)((double)cornerPoints[i].y * scale - invisibleHeight / 2.0);
            normalizedCornerPoints[i] = new Point(x, y);
        }
        return normalizedCornerPoints;
    }
}

