/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import com.getcapacitor.Bridge;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.NativePlugin;
import com.getcapacitor.PermissionState;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginConfig;
import com.getcapacitor.PluginHandle;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.ActivityCallback;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.annotation.Permission;
import com.getcapacitor.annotation.PermissionCallback;
import com.getcapacitor.util.PermissionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;

public class Plugin {
    private static final String BUNDLE_PERSISTED_OPTIONS_JSON_KEY = "_json";
    protected Bridge bridge;
    protected PluginHandle handle;
    @Deprecated
    protected PluginCall savedLastCall;
    private final Map<String, List<PluginCall>> eventListeners;
    private final Map<String, ActivityResultLauncher<Intent>> activityLaunchers = new HashMap<String, ActivityResultLauncher<Intent>>();
    private final Map<String, ActivityResultLauncher<String[]>> permissionLaunchers = new HashMap<String, ActivityResultLauncher<String[]>>();
    private String lastPluginCallId;
    private final Map<String, List<JSObject>> retainedEventArguments;

    public Plugin() {
        this.eventListeners = new HashMap<String, List<PluginCall>>();
        this.retainedEventArguments = new HashMap<String, List<JSObject>>();
    }

    public void load() {
    }

    void initializeActivityLaunchers() {
        ArrayList<Method> pluginClassMethods = new ArrayList<Method>();
        Class<?> pluginCursor = this.getClass();
        while (!pluginCursor.getName().equals(Object.class.getName())) {
            pluginClassMethods.addAll(Arrays.asList(pluginCursor.getDeclaredMethods()));
            pluginCursor = pluginCursor.getSuperclass();
        }
        for (Method method : pluginClassMethods) {
            ActivityResultLauncher launcher;
            if (method.isAnnotationPresent(ActivityCallback.class)) {
                launcher = this.bridge.registerForActivityResult(new ActivityResultContracts.StartActivityForResult(), result -> this.triggerActivityCallback(method, (ActivityResult)result));
                this.activityLaunchers.put(method.getName(), launcher);
                continue;
            }
            if (!method.isAnnotationPresent(PermissionCallback.class)) continue;
            launcher = this.bridge.registerForActivityResult(new ActivityResultContracts.RequestMultiplePermissions(), permissions -> this.triggerPermissionCallback(method, (Map<String, Boolean>)permissions));
            this.permissionLaunchers.put(method.getName(), launcher);
        }
    }

    private void triggerPermissionCallback(Method method, Map<String, Boolean> permissionResultMap) {
        PluginCall savedCall = this.bridge.getPermissionCall(this.handle.getId());
        if (this.bridge.validatePermissions(this, savedCall, permissionResultMap)) {
            try {
                method.setAccessible(true);
                method.invoke((Object)this, savedCall);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void triggerActivityCallback(Method method, ActivityResult result) {
        PluginCall savedCall = this.bridge.getSavedCall(this.lastPluginCallId);
        if (savedCall == null) {
            savedCall = this.bridge.getPluginCallForLastActivity();
        }
        try {
            method.setAccessible(true);
            method.invoke((Object)this, savedCall, result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void startActivityForResult(PluginCall call, Intent intent, String callbackName) {
        ActivityResultLauncher<Intent> activityResultLauncher = this.getActivityLauncherOrReject(call, callbackName);
        if (activityResultLauncher == null) {
            return;
        }
        this.bridge.setPluginCallForLastActivity(call);
        this.lastPluginCallId = call.getCallbackId();
        this.bridge.saveCall(call);
        activityResultLauncher.launch((Object)intent);
    }

    private void permissionActivityResult(PluginCall call, String[] permissionStrings, String callbackName) {
        ActivityResultLauncher<String[]> permissionResultLauncher = this.getPermissionLauncherOrReject(call, callbackName);
        if (permissionResultLauncher == null) {
            return;
        }
        this.bridge.savePermissionCall(call);
        permissionResultLauncher.launch((Object)permissionStrings);
    }

    public Context getContext() {
        return this.bridge.getContext();
    }

    public AppCompatActivity getActivity() {
        return this.bridge.getActivity();
    }

    public void setBridge(Bridge bridge) {
        this.bridge = bridge;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public void setPluginHandle(PluginHandle pluginHandle) {
        this.handle = pluginHandle;
    }

    public PluginHandle getPluginHandle() {
        return this.handle;
    }

    public String getAppId() {
        return this.getContext().getPackageName();
    }

    @Deprecated
    public void saveCall(PluginCall lastCall) {
        this.savedLastCall = lastCall;
    }

    @Deprecated
    public void freeSavedCall() {
        this.savedLastCall.release(this.bridge);
        this.savedLastCall = null;
    }

    @Deprecated
    public PluginCall getSavedCall() {
        return this.savedLastCall;
    }

    public PluginConfig getConfig() {
        return this.bridge.getConfig().getPluginConfiguration(this.handle.getId());
    }

    @Deprecated
    public Object getConfigValue(String key) {
        try {
            PluginConfig pluginConfig = this.getConfig();
            return pluginConfig.getConfigJSON().get(key);
        }
        catch (JSONException ex) {
            return null;
        }
    }

    @Deprecated
    public boolean hasDefinedPermissions(String[] permissions) {
        for (String permission2 : permissions) {
            if (PermissionHelper.hasDefinedPermission(this.getContext(), permission2)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean hasDefinedRequiredPermissions() {
        CapacitorPlugin annotation = this.handle.getPluginAnnotation();
        if (annotation == null) {
            NativePlugin legacyAnnotation = this.handle.getLegacyPluginAnnotation();
            return this.hasDefinedPermissions(legacyAnnotation.permissions());
        }
        for (Permission perm : annotation.permissions()) {
            for (String permString : perm.strings()) {
                if (PermissionHelper.hasDefinedPermission(this.getContext(), permString)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPermissionDeclared(String alias) {
        CapacitorPlugin annotation = this.handle.getPluginAnnotation();
        if (annotation != null) {
            for (Permission perm : annotation.permissions()) {
                if (!alias.equalsIgnoreCase(perm.alias())) continue;
                boolean result = true;
                for (String permString : perm.strings()) {
                    result = result && PermissionHelper.hasDefinedPermission(this.getContext(), permString);
                }
                return result;
            }
        }
        Logger.error(String.format("isPermissionDeclared: No alias defined for %s or missing @CapacitorPlugin annotation.", alias));
        return false;
    }

    @Deprecated
    public boolean hasPermission(String permission2) {
        return ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)permission2) == 0;
    }

    @Deprecated
    public boolean hasRequiredPermissions() {
        CapacitorPlugin annotation = this.handle.getPluginAnnotation();
        if (annotation == null) {
            NativePlugin legacyAnnotation = this.handle.getLegacyPluginAnnotation();
            for (String perm : legacyAnnotation.permissions()) {
                if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)perm) == 0) continue;
                return false;
            }
            return true;
        }
        for (Permission perm : annotation.permissions()) {
            for (String permString : perm.strings()) {
                if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)permString) == 0) continue;
                return false;
            }
        }
        return true;
    }

    protected void requestAllPermissions(@NonNull PluginCall call, @NonNull String callbackName) {
        CapacitorPlugin annotation = this.handle.getPluginAnnotation();
        if (annotation != null) {
            HashSet<String> perms = new HashSet<String>();
            for (Permission perm : annotation.permissions()) {
                perms.addAll(Arrays.asList(perm.strings()));
            }
            this.permissionActivityResult(call, perms.toArray(new String[0]), callbackName);
        }
    }

    protected void requestPermissionForAlias(@NonNull String alias, @NonNull PluginCall call, @NonNull String callbackName) {
        this.requestPermissionForAliases(new String[]{alias}, call, callbackName);
    }

    protected void requestPermissionForAliases(@NonNull String[] aliases, @NonNull PluginCall call, @NonNull String callbackName) {
        if (aliases.length == 0) {
            Logger.error("No permission alias was provided");
            return;
        }
        String[] permissions = this.getPermissionStringsForAliases(aliases);
        if (permissions.length > 0) {
            this.permissionActivityResult(call, permissions, callbackName);
        }
    }

    private String[] getPermissionStringsForAliases(@NonNull String[] aliases) {
        CapacitorPlugin annotation = this.handle.getPluginAnnotation();
        HashSet<String> perms = new HashSet<String>();
        for (Permission perm : annotation.permissions()) {
            if (!Arrays.asList(aliases).contains(perm.alias())) continue;
            perms.addAll(Arrays.asList(perm.strings()));
        }
        return perms.toArray(new String[0]);
    }

    @Nullable
    private ActivityResultLauncher<Intent> getActivityLauncherOrReject(PluginCall call, String methodName) {
        ActivityResultLauncher<Intent> activityLauncher = this.activityLaunchers.get(methodName);
        if (activityLauncher == null) {
            String registerError = "There is no ActivityCallback method registered for the name: %s. Please define a callback method annotated with @ActivityCallback that receives arguments: (PluginCall, ActivityResult)";
            registerError = String.format(Locale.US, registerError, methodName);
            Logger.error(registerError);
            call.reject(registerError);
            return null;
        }
        return activityLauncher;
    }

    @Nullable
    private ActivityResultLauncher<String[]> getPermissionLauncherOrReject(PluginCall call, String methodName) {
        ActivityResultLauncher<String[]> permissionLauncher = this.permissionLaunchers.get(methodName);
        if (permissionLauncher == null) {
            String registerError = "There is no PermissionCallback method registered for the name: %s. Please define a callback method annotated with @PermissionCallback that receives arguments: (PluginCall)";
            registerError = String.format(Locale.US, registerError, methodName);
            Logger.error(registerError);
            call.reject(registerError);
            return null;
        }
        return permissionLauncher;
    }

    @Deprecated
    public void pluginRequestAllPermissions() {
        NativePlugin legacyAnnotation = this.handle.getLegacyPluginAnnotation();
        ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])legacyAnnotation.permissions(), (int)legacyAnnotation.permissionRequestCode());
    }

    @Deprecated
    public void pluginRequestPermission(String permission2, int requestCode) {
        ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])new String[]{permission2}, (int)requestCode);
    }

    @Deprecated
    public void pluginRequestPermissions(String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])permissions, (int)requestCode);
    }

    public PermissionState getPermissionState(String alias) {
        return this.getPermissionStates().get(alias);
    }

    public Map<String, PermissionState> getPermissionStates() {
        return this.bridge.getPermissionStates(this);
    }

    private void addEventListener(String eventName, PluginCall call) {
        List<PluginCall> listeners = this.eventListeners.get(eventName);
        if (listeners == null || listeners.isEmpty()) {
            listeners = new ArrayList<PluginCall>();
            this.eventListeners.put(eventName, listeners);
            listeners.add(call);
            this.sendRetainedArgumentsForEvent(eventName);
        } else {
            listeners.add(call);
        }
    }

    private void removeEventListener(String eventName, PluginCall call) {
        List<PluginCall> listeners = this.eventListeners.get(eventName);
        if (listeners == null) {
            return;
        }
        listeners.remove(call);
    }

    protected void notifyListeners(String eventName, JSObject data, boolean retainUntilConsumed) {
        Logger.verbose(this.getLogTag(), "Notifying listeners for event " + eventName);
        List<PluginCall> listeners = this.eventListeners.get(eventName);
        if (listeners == null || listeners.isEmpty()) {
            Logger.debug(this.getLogTag(), "No listeners found for event " + eventName);
            if (retainUntilConsumed) {
                List<JSObject> argList = this.retainedEventArguments.get(eventName);
                if (argList == null) {
                    argList = new ArrayList<JSObject>();
                }
                argList.add(data);
                this.retainedEventArguments.put(eventName, argList);
            }
            return;
        }
        CopyOnWriteArrayList<PluginCall> listenersCopy = new CopyOnWriteArrayList<PluginCall>(listeners);
        for (PluginCall call : listenersCopy) {
            call.resolve(data);
        }
    }

    protected void notifyListeners(String eventName, JSObject data) {
        this.notifyListeners(eventName, data, false);
    }

    protected boolean hasListeners(String eventName) {
        List<PluginCall> listeners = this.eventListeners.get(eventName);
        if (listeners == null) {
            return false;
        }
        return !listeners.isEmpty();
    }

    private void sendRetainedArgumentsForEvent(String eventName) {
        List<JSObject> retainedArgs = this.retainedEventArguments.get(eventName);
        if (retainedArgs == null) {
            return;
        }
        this.retainedEventArguments.remove(eventName);
        for (JSObject retained : retainedArgs) {
            this.notifyListeners(eventName, retained);
        }
    }

    @PluginMethod(returnType="none")
    public void addListener(PluginCall call) {
        String eventName = call.getString("eventName");
        call.setKeepAlive(true);
        this.addEventListener(eventName, call);
    }

    @PluginMethod(returnType="none")
    public void removeListener(PluginCall call) {
        String eventName = call.getString("eventName");
        String callbackId = call.getString("callbackId");
        PluginCall savedCall = this.bridge.getSavedCall(callbackId);
        if (savedCall != null) {
            this.removeEventListener(eventName, savedCall);
            this.bridge.releaseCall(savedCall);
        }
    }

    @PluginMethod(returnType="promise")
    public void removeAllListeners(PluginCall call) {
        this.eventListeners.clear();
        call.resolve();
    }

    @PluginMethod
    @PermissionCallback
    public void checkPermissions(PluginCall pluginCall) {
        Map<String, PermissionState> permissionsResult = this.getPermissionStates();
        if (permissionsResult.size() == 0) {
            pluginCall.resolve();
        } else {
            JSObject permissionsResultJSON = new JSObject();
            for (Map.Entry<String, PermissionState> entry : permissionsResult.entrySet()) {
                permissionsResultJSON.put(entry.getKey(), (Object)entry.getValue());
            }
            pluginCall.resolve(permissionsResultJSON);
        }
    }

    @PluginMethod
    public void requestPermissions(PluginCall call) {
        CapacitorPlugin annotation = this.handle.getPluginAnnotation();
        if (annotation == null) {
            this.handleLegacyPermission(call);
        } else {
            String[] permAliases = null;
            HashSet<String> autoGrantPerms = new HashSet<String>();
            JSArray providedPerms = call.getArray("permissions");
            List providedPermsList = null;
            if (providedPerms != null) {
                try {
                    providedPermsList = providedPerms.toList();
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            HashSet<String> aliasSet = new HashSet<String>();
            if (providedPermsList == null || providedPermsList.isEmpty()) {
                for (Permission perm : annotation.permissions()) {
                    if (perm.strings().length == 0 || perm.strings().length == 1 && perm.strings()[0].isEmpty()) {
                        if (perm.alias().isEmpty()) continue;
                        autoGrantPerms.add(perm.alias());
                        continue;
                    }
                    aliasSet.add(perm.alias());
                }
                permAliases = aliasSet.toArray(new String[0]);
            } else {
                for (Permission perm : annotation.permissions()) {
                    if (!providedPermsList.contains(perm.alias())) continue;
                    aliasSet.add(perm.alias());
                }
                if (aliasSet.isEmpty()) {
                    call.reject("No valid permission alias was requested of this plugin.");
                } else {
                    permAliases = aliasSet.toArray(new String[0]);
                }
            }
            if (permAliases != null && permAliases.length > 0) {
                this.requestPermissionForAliases(permAliases, call, "checkPermissions");
            } else if (!autoGrantPerms.isEmpty()) {
                JSObject permissionsResults = new JSObject();
                for (String perm : autoGrantPerms) {
                    permissionsResults.put(perm, PermissionState.GRANTED.toString());
                }
                call.resolve(permissionsResults);
            } else {
                call.resolve();
            }
        }
    }

    private void handleLegacyPermission(PluginCall call) {
        NativePlugin legacyAnnotation = this.handle.getLegacyPluginAnnotation();
        String[] perms = legacyAnnotation.permissions();
        if (perms.length > 0) {
            this.saveCall(call);
            this.pluginRequestPermissions(perms, legacyAnnotation.permissionRequestCode());
        } else {
            call.resolve();
        }
    }

    @Deprecated
    protected void handleRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (!this.hasDefinedPermissions(permissions)) {
            String[] missing;
            StringBuilder builder = new StringBuilder();
            builder.append("Missing the following permissions in AndroidManifest.xml:\n");
            for (String perm : missing = PermissionHelper.getUndefinedPermissions(this.getContext(), permissions)) {
                builder.append(perm + "\n");
            }
            this.savedLastCall.reject(builder.toString());
            this.savedLastCall = null;
        }
    }

    protected Bundle saveInstanceState() {
        PluginCall savedCall = this.bridge.getSavedCall(this.lastPluginCallId);
        if (savedCall == null) {
            return null;
        }
        Bundle ret = new Bundle();
        JSObject callData = savedCall.getData();
        if (callData != null) {
            ret.putString(BUNDLE_PERSISTED_OPTIONS_JSON_KEY, callData.toString());
        }
        return ret;
    }

    protected void restoreState(Bundle state) {
    }

    @Deprecated
    protected void handleOnActivityResult(int requestCode, int resultCode, Intent data) {
    }

    protected void handleOnNewIntent(Intent intent) {
    }

    protected void handleOnConfigurationChanged(Configuration newConfig) {
    }

    protected void handleOnStart() {
    }

    protected void handleOnRestart() {
    }

    protected void handleOnResume() {
    }

    protected void handleOnPause() {
    }

    protected void handleOnStop() {
    }

    protected void handleOnDestroy() {
    }

    public Boolean shouldOverrideLoad(Uri url) {
        return null;
    }

    @Deprecated
    protected void startActivityForResult(PluginCall call, Intent intent, int resultCode) {
        this.bridge.startActivityForPluginWithResult(call, intent, resultCode);
    }

    public void execute(Runnable runnable) {
        this.bridge.execute(runnable);
    }

    protected String getLogTag(String ... subTags) {
        return Logger.tags(subTags);
    }

    protected String getLogTag() {
        return Logger.tags(this.getClass().getSimpleName());
    }
}

