/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.content.Context;
import android.net.Uri;
import android.util.TypedValue;
import com.getcapacitor.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;

public class AndroidProtocolHandler {
    private Context context;

    public AndroidProtocolHandler(Context context) {
        this.context = context;
    }

    public InputStream openAsset(String path) throws IOException {
        return this.context.getAssets().open(path, 2);
    }

    public InputStream openResource(Uri uri) {
        assert (uri.getPath() != null);
        List pathSegments = uri.getPathSegments();
        String assetType = (String)pathSegments.get(pathSegments.size() - 2);
        String assetName = (String)pathSegments.get(pathSegments.size() - 1);
        assetName = assetName.split("\\.")[0];
        try {
            int fieldId;
            int valueType;
            if (this.context.getApplicationContext() != null) {
                this.context = this.context.getApplicationContext();
            }
            if ((valueType = AndroidProtocolHandler.getValueType(this.context, fieldId = AndroidProtocolHandler.getFieldId(this.context, assetType, assetName))) == 3) {
                return this.context.getResources().openRawResource(fieldId);
            }
            Logger.error("Asset not of type string: " + uri);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            Logger.error("Unable to open resource URL: " + uri, e);
        }
        return null;
    }

    private static int getFieldId(Context context, String assetType, String assetName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> d = context.getClassLoader().loadClass(context.getPackageName() + ".R$" + assetType);
        Field field = d.getField(assetName);
        return field.getInt(null);
    }

    public InputStream openFile(String filePath) throws IOException {
        String realPath = filePath.replace("/_capacitor_file_", "");
        File localFile = new File(realPath);
        return new FileInputStream(localFile);
    }

    public InputStream openContentUrl(Uri uri) throws IOException {
        Integer port = uri.getPort();
        String baseUrl = uri.getScheme() + "://" + uri.getHost();
        if (port != -1) {
            baseUrl = baseUrl + ":" + port;
        }
        String realPath = uri.toString().replace(baseUrl + "/_capacitor_content_", "content:/");
        InputStream stream = null;
        try {
            stream = this.context.getContentResolver().openInputStream(Uri.parse((String)realPath));
        }
        catch (SecurityException e) {
            Logger.error("Unable to open content URL: " + uri, e);
        }
        return stream;
    }

    private static int getValueType(Context context, int fieldId) {
        TypedValue value = new TypedValue();
        context.getResources().getValue(fieldId, value, true);
        return value.type;
    }
}

