/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.getcapacitor.Bridge;
import com.getcapacitor.WebViewListener;
import java.util.List;

public class BridgeWebViewClient
extends WebViewClient {
    private Bridge bridge;

    public BridgeWebViewClient(Bridge bridge) {
        this.bridge = bridge;
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        return this.bridge.getLocalServer().shouldInterceptRequest(request);
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        Uri url = request.getUrl();
        return this.bridge.launchIntent(url);
    }

    @Deprecated
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return this.bridge.launchIntent(Uri.parse((String)url));
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        List<WebViewListener> webViewListeners = this.bridge.getWebViewListeners();
        if (webViewListeners != null && view.getProgress() == 100) {
            for (WebViewListener listener : this.bridge.getWebViewListeners()) {
                listener.onPageLoaded(view);
            }
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        String errorPath;
        super.onReceivedError(view, request, error);
        List<WebViewListener> webViewListeners = this.bridge.getWebViewListeners();
        if (webViewListeners != null) {
            for (WebViewListener listener : this.bridge.getWebViewListeners()) {
                listener.onReceivedError(view);
            }
        }
        if ((errorPath = this.bridge.getErrorUrl()) != null && request.isForMainFrame()) {
            view.loadUrl(errorPath);
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.bridge.reset();
        List<WebViewListener> webViewListeners = this.bridge.getWebViewListeners();
        if (webViewListeners != null) {
            for (WebViewListener listener : this.bridge.getWebViewListeners()) {
                listener.onPageStarted(view);
            }
        }
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        String errorPath;
        super.onReceivedHttpError(view, request, errorResponse);
        List<WebViewListener> webViewListeners = this.bridge.getWebViewListeners();
        if (webViewListeners != null) {
            for (WebViewListener listener : this.bridge.getWebViewListeners()) {
                listener.onReceivedHttpError(view);
            }
        }
        if ((errorPath = this.bridge.getErrorUrl()) != null && request.isForMainFrame()) {
            view.loadUrl(errorPath);
        }
    }

    public boolean onRenderProcessGone(WebView view, RenderProcessGoneDetail detail) {
        super.onRenderProcessGone(view, detail);
        boolean result = false;
        List<WebViewListener> webViewListeners = this.bridge.getWebViewListeners();
        if (webViewListeners != null) {
            for (WebViewListener listener : this.bridge.getWebViewListeners()) {
                result = listener.onRenderProcessGone(view, detail) || result;
            }
        }
        return result;
    }
}

