/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.content.Context;
import android.text.TextUtils;
import com.getcapacitor.FileUtils;
import com.getcapacitor.JSExportException;
import com.getcapacitor.Logger;
import com.getcapacitor.PluginHandle;
import com.getcapacitor.PluginMethodHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSExport {
    private static String CATCHALL_OPTIONS_PARAM = "_options";
    private static String CALLBACK_PARAM = "_callback";

    public static String getGlobalJS(Context context, boolean loggingEnabled, boolean isDebug) {
        return "window.Capacitor = { DEBUG: " + isDebug + ", isLoggingEnabled: " + loggingEnabled + ", Plugins: {} };";
    }

    public static String getCordovaJS(Context context) {
        String fileContent = "";
        try {
            fileContent = FileUtils.readFileFromAssets(context.getAssets(), "public/cordova.js");
        }
        catch (IOException ex) {
            Logger.error("Unable to read public/cordova.js file, Cordova plugins will not work");
        }
        return fileContent;
    }

    public static String getCordovaPluginsFileJS(Context context) {
        String fileContent = "";
        try {
            fileContent = FileUtils.readFileFromAssets(context.getAssets(), "public/cordova_plugins.js");
        }
        catch (IOException ex) {
            Logger.error("Unable to read public/cordova_plugins.js file, Cordova plugins will not work");
        }
        return fileContent;
    }

    public static String getPluginJS(Collection<PluginHandle> plugins) {
        ArrayList<String> lines = new ArrayList<String>();
        JSONArray pluginArray = new JSONArray();
        lines.add("// Begin: Capacitor Plugin JS");
        for (PluginHandle plugin : plugins) {
            lines.add("(function(w) {\nvar a = (w.Capacitor = w.Capacitor || {});\nvar p = (a.Plugins = a.Plugins || {});\nvar t = (p['" + plugin.getId() + "'] = {});\nt.addListener = function(eventName, callback) {\n  return w.Capacitor.addListener('" + plugin.getId() + "', eventName, callback);\n}");
            Collection<PluginMethodHandle> methods = plugin.getMethods();
            for (PluginMethodHandle method : methods) {
                if (method.getName().equals("addListener") || method.getName().equals("removeListener")) continue;
                lines.add(JSExport.generateMethodJS(plugin, method));
            }
            lines.add("})(window);\n");
            pluginArray.put((Object)JSExport.createPluginHeader(plugin));
        }
        return TextUtils.join((CharSequence)"\n", lines) + "\nwindow.Capacitor.PluginHeaders = " + pluginArray.toString() + ";";
    }

    public static String getCordovaPluginJS(Context context) {
        return JSExport.getFilesContent(context, "public/plugins");
    }

    public static String getFilesContent(Context context, String path) {
        StringBuilder builder;
        block4: {
            builder = new StringBuilder();
            try {
                String[] content = context.getAssets().list(path);
                if (content.length > 0) {
                    for (String file : content) {
                        if (file.endsWith(".map")) continue;
                        builder.append(JSExport.getFilesContent(context, path + "/" + file));
                    }
                    break block4;
                }
                return FileUtils.readFileFromAssets(context.getAssets(), path);
            }
            catch (IOException ex) {
                Logger.warn("Unable to read file at path " + path);
            }
        }
        return builder.toString();
    }

    private static JSONObject createPluginHeader(PluginHandle plugin) {
        JSONObject pluginObj = new JSONObject();
        Collection<PluginMethodHandle> methods = plugin.getMethods();
        try {
            String id2 = plugin.getId();
            JSONArray methodArray = new JSONArray();
            pluginObj.put("name", (Object)id2);
            for (PluginMethodHandle method : methods) {
                methodArray.put((Object)JSExport.createPluginMethodHeader(method));
            }
            pluginObj.put("methods", (Object)methodArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return pluginObj;
    }

    private static JSONObject createPluginMethodHeader(PluginMethodHandle method) {
        JSONObject methodObj = new JSONObject();
        try {
            methodObj.put("name", (Object)method.getName());
            if (!method.getReturnType().equals("none")) {
                methodObj.put("rtype", (Object)method.getReturnType());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return methodObj;
    }

    public static String getBridgeJS(Context context) throws JSExportException {
        return JSExport.getFilesContent(context, "native-bridge.js");
    }

    private static String generateMethodJS(PluginHandle plugin, PluginMethodHandle method) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> args = new ArrayList<String>();
        args.add(CATCHALL_OPTIONS_PARAM);
        String returnType = method.getReturnType();
        if (returnType.equals("callback")) {
            args.add(CALLBACK_PARAM);
        }
        lines.add("t['" + method.getName() + "'] = function(" + TextUtils.join((CharSequence)", ", args) + ") {");
        switch (returnType) {
            case "none": {
                lines.add("return w.Capacitor.nativeCallback('" + plugin.getId() + "', '" + method.getName() + "', " + CATCHALL_OPTIONS_PARAM + ")");
                break;
            }
            case "promise": {
                lines.add("return w.Capacitor.nativePromise('" + plugin.getId() + "', '" + method.getName() + "', " + CATCHALL_OPTIONS_PARAM + ")");
                break;
            }
            case "callback": {
                lines.add("return w.Capacitor.nativeCallback('" + plugin.getId() + "', '" + method.getName() + "', " + CATCHALL_OPTIONS_PARAM + ", " + CALLBACK_PARAM + ")");
                break;
            }
        }
        lines.add("}");
        return TextUtils.join((CharSequence)"\n", lines);
    }
}

