/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.text.TextUtils;
import android.util.Log;
import com.getcapacitor.CapConfig;

public class Logger {
    public static final String LOG_TAG_CORE = "Capacitor";
    public static CapConfig config;
    private static Logger instance;

    private static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public static void init(CapConfig config) {
        Logger.getInstance().loadConfig(config);
    }

    private void loadConfig(CapConfig config) {
        Logger.config = config;
    }

    public static String tags(String ... subtags) {
        if (subtags != null && subtags.length > 0) {
            return "Capacitor/" + TextUtils.join((CharSequence)"/", (Object[])subtags);
        }
        return LOG_TAG_CORE;
    }

    public static void verbose(String message) {
        Logger.verbose(LOG_TAG_CORE, message);
    }

    public static void verbose(String tag, String message) {
        if (!Logger.shouldLog()) {
            return;
        }
        Log.v((String)tag, (String)message);
    }

    public static void debug(String message) {
        Logger.debug(LOG_TAG_CORE, message);
    }

    public static void debug(String tag, String message) {
        if (!Logger.shouldLog()) {
            return;
        }
        Log.d((String)tag, (String)message);
    }

    public static void info(String message) {
        Logger.info(LOG_TAG_CORE, message);
    }

    public static void info(String tag, String message) {
        if (!Logger.shouldLog()) {
            return;
        }
        Log.i((String)tag, (String)message);
    }

    public static void warn(String message) {
        Logger.warn(LOG_TAG_CORE, message);
    }

    public static void warn(String tag, String message) {
        if (!Logger.shouldLog()) {
            return;
        }
        Log.w((String)tag, (String)message);
    }

    public static void error(String message) {
        Logger.error(LOG_TAG_CORE, message, null);
    }

    public static void error(String message, Throwable e) {
        Logger.error(LOG_TAG_CORE, message, e);
    }

    public static void error(String tag, String message, Throwable e) {
        if (!Logger.shouldLog()) {
            return;
        }
        Log.e((String)tag, (String)message, (Throwable)e);
    }

    public static boolean shouldLog() {
        return config == null || config.isLoggingEnabled();
    }
}

