/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.content.res.AssetManager;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginLoadException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginManager {
    private final AssetManager assetManager;

    public PluginManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    public List<Class<? extends Plugin>> loadPluginClasses() throws PluginLoadException {
        JSONArray pluginsJSON = this.parsePluginsJSON();
        ArrayList<Class<? extends Plugin>> pluginList = new ArrayList<Class<? extends Plugin>>();
        try {
            int size = pluginsJSON.length();
            for (int i = 0; i < size; ++i) {
                JSONObject pluginJSON = pluginsJSON.getJSONObject(i);
                String classPath = pluginJSON.getString("classpath");
                Class<?> c = Class.forName(classPath);
                pluginList.add(c.asSubclass(Plugin.class));
            }
        }
        catch (JSONException e) {
            throw new PluginLoadException("Could not parse capacitor.plugins.json as JSON");
        }
        catch (ClassNotFoundException e) {
            throw new PluginLoadException("Could not find class by class path: " + e.getMessage());
        }
        return pluginList;
    }

    private JSONArray parsePluginsJSON() throws PluginLoadException {
        JSONArray jSONArray;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.assetManager.open("capacitor.plugins.json")));
        try {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String jsonString = builder.toString();
            jSONArray = new JSONArray(jsonString);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PluginLoadException("Could not load capacitor.plugins.json");
            }
            catch (JSONException e) {
                throw new PluginLoadException("Could not parse capacitor.plugins.json as JSON");
            }
        }
        reader.close();
        return jSONArray;
    }
}

