/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class PluginResult {
    private final JSObject json;

    public PluginResult() {
        this(new JSObject());
    }

    public PluginResult(JSObject json) {
        this.json = json;
    }

    public PluginResult put(String name, boolean value) {
        return this.jsonPut(name, value);
    }

    public PluginResult put(String name, double value) {
        return this.jsonPut(name, value);
    }

    public PluginResult put(String name, int value) {
        return this.jsonPut(name, value);
    }

    public PluginResult put(String name, long value) {
        return this.jsonPut(name, value);
    }

    public PluginResult put(String name, Date value) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        return this.jsonPut(name, df.format(value));
    }

    public PluginResult put(String name, Object value) {
        return this.jsonPut(name, value);
    }

    public PluginResult put(String name, PluginResult value) {
        return this.jsonPut(name, (Object)value.json);
    }

    PluginResult jsonPut(String name, Object value) {
        try {
            this.json.put(name, value);
        }
        catch (Exception ex) {
            Logger.error(Logger.tags("Plugin"), "", ex);
        }
        return this;
    }

    public String toString() {
        return this.json.toString();
    }

    public JSObject getWrappedResult() {
        JSObject ret = new JSObject();
        ret.put("pluginId", this.json.getString("pluginId"));
        ret.put("methodName", this.json.getString("methodName"));
        ret.put("success", this.json.getBoolean("success", false));
        ret.put("data", (Object)this.json.getJSObject("data"));
        ret.put("error", (Object)this.json.getJSObject("error"));
        return ret;
    }
}

