/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor;

import android.net.Uri;
import com.getcapacitor.util.HostMask;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class UriMatcher {
    static final Pattern PATH_SPLIT_PATTERN = Pattern.compile("/");
    private static final int EXACT = 0;
    private static final int TEXT = 1;
    private static final int REST = 2;
    private static final int MASK = 3;
    private Object mCode;
    private int mWhich;
    private String mText;
    private ArrayList<UriMatcher> mChildren;

    public UriMatcher(Object code) {
        this.mCode = code;
        this.mWhich = -1;
        this.mChildren = new ArrayList();
        this.mText = null;
    }

    private UriMatcher() {
        this.mCode = null;
        this.mWhich = -1;
        this.mChildren = new ArrayList();
        this.mText = null;
    }

    public void addURI(String scheme, String authority, String path, Object code) {
        if (code == null) {
            throw new IllegalArgumentException("Code can't be null");
        }
        String[] tokens = null;
        if (path != null) {
            String newPath = path;
            if (!path.isEmpty() && path.charAt(0) == '/') {
                newPath = path.substring(1);
            }
            tokens = PATH_SPLIT_PATTERN.split(newPath);
        }
        int numTokens = tokens != null ? tokens.length : 0;
        UriMatcher node = this;
        for (int i = -2; i < numTokens; ++i) {
            UriMatcher child;
            int j;
            String token = i == -2 ? scheme : (i == -1 ? authority : tokens[i]);
            ArrayList<UriMatcher> children = node.mChildren;
            int numChildren = children.size();
            for (j = 0; j < numChildren; ++j) {
                child = children.get(j);
                if (!token.equals(child.mText)) continue;
                node = child;
                break;
            }
            if (j != numChildren) continue;
            child = new UriMatcher();
            child.mWhich = i == -1 && token.contains("*") ? 3 : (token.equals("**") ? 2 : (token.equals("*") ? 1 : 0));
            child.mText = token;
            node.mChildren.add(child);
            node = child;
        }
        node.mCode = code;
    }

    public Object match(Uri uri) {
        List pathSegments = uri.getPathSegments();
        int li = pathSegments.size();
        UriMatcher node = this;
        if (li == 0 && uri.getAuthority() == null) {
            return this.mCode;
        }
        for (int i = -2; i < li; ++i) {
            String u = i == -2 ? uri.getScheme() : (i == -1 ? uri.getAuthority() : (String)pathSegments.get(i));
            ArrayList<UriMatcher> list = node.mChildren;
            if (list == null) break;
            node = null;
            int lj = list.size();
            for (int j = 0; j < lj; ++j) {
                UriMatcher n = list.get(j);
                switch (n.mWhich) {
                    case 3: {
                        if (!HostMask.Parser.parse(n.mText).matches(u)) break;
                        node = n;
                        break;
                    }
                    case 0: {
                        if (!n.mText.equals(u)) break;
                        node = n;
                        break;
                    }
                    case 1: {
                        node = n;
                        break;
                    }
                    case 2: {
                        return n.mCode;
                    }
                }
                if (node != null) break;
            }
            if (node != null) continue;
            return null;
        }
        return node.mCode;
    }
}

