/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor.cordova;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.View;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.getcapacitor.cordova.CapacitorCordovaCookieManager;
import java.util.List;
import java.util.Map;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.ICordovaCookieManager;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;

public class MockCordovaWebViewImpl
implements CordovaWebView {
    private Context context;
    private PluginManager pluginManager;
    private CordovaPreferences preferences;
    private CordovaResourceApi resourceApi;
    private NativeToJsMessageQueue nativeToJsMessageQueue;
    private CordovaInterface cordova;
    private CapacitorCordovaCookieManager cookieManager;
    private WebView webView;
    private boolean hasPausedEver;

    public MockCordovaWebViewImpl(Context context) {
        this.context = context;
    }

    public void init(CordovaInterface cordova, List<PluginEntry> pluginEntries, CordovaPreferences preferences) {
        this.cordova = cordova;
        this.preferences = preferences;
        this.pluginManager = new PluginManager((CordovaWebView)this, this.cordova, pluginEntries);
        this.resourceApi = new CordovaResourceApi(this.context, this.pluginManager);
        this.pluginManager.init();
    }

    public void init(CordovaInterface cordova, List<PluginEntry> pluginEntries, CordovaPreferences preferences, WebView webView) {
        this.cordova = cordova;
        this.webView = webView;
        this.preferences = preferences;
        this.pluginManager = new PluginManager((CordovaWebView)this, this.cordova, pluginEntries);
        this.resourceApi = new CordovaResourceApi(this.context, this.pluginManager);
        this.nativeToJsMessageQueue = new NativeToJsMessageQueue();
        this.nativeToJsMessageQueue.addBridgeMode((NativeToJsMessageQueue.BridgeMode)new CapacitorEvalBridgeMode(webView, this.cordova));
        this.nativeToJsMessageQueue.setBridgeMode(0);
        this.cookieManager = new CapacitorCordovaCookieManager(webView);
        this.pluginManager.init();
    }

    public boolean isInitialized() {
        return this.cordova != null;
    }

    public View getView() {
        return this.webView;
    }

    public void loadUrlIntoView(String url, boolean recreatePlugins) {
        if (url.equals("about:blank") || url.startsWith("javascript:")) {
            this.webView.loadUrl(url);
            return;
        }
    }

    public void stopLoading() {
    }

    public boolean canGoBack() {
        return false;
    }

    public void clearCache() {
    }

    @Deprecated
    public void clearCache(boolean b) {
    }

    public void clearHistory() {
    }

    public boolean backHistory() {
        return false;
    }

    public void handlePause(boolean keepRunning) {
        if (!this.isInitialized()) {
            return;
        }
        this.hasPausedEver = true;
        this.pluginManager.onPause(keepRunning);
        this.triggerDocumentEvent("pause");
        if (!keepRunning) {
            this.setPaused(true);
        }
    }

    public void onNewIntent(Intent intent) {
        if (this.pluginManager != null) {
            this.pluginManager.onNewIntent(intent);
        }
    }

    public void handleResume(boolean keepRunning) {
        if (!this.isInitialized()) {
            return;
        }
        this.setPaused(false);
        this.pluginManager.onResume(keepRunning);
        if (this.hasPausedEver) {
            this.triggerDocumentEvent("resume");
        }
    }

    public void handleStart() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStart();
    }

    public void handleStop() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStop();
    }

    public void handleDestroy() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onDestroy();
    }

    @Deprecated
    public void sendJavascript(String statememt) {
        this.nativeToJsMessageQueue.addJavaScript(statememt);
    }

    public void eval(String js, ValueCallback<String> callback) {
        Handler mainHandler = new Handler(this.context.getMainLooper());
        mainHandler.post(() -> this.webView.evaluateJavascript(js, callback));
    }

    public void triggerDocumentEvent(String eventName) {
        this.eval("window.Capacitor.triggerEvent('" + eventName + "', 'document');", (ValueCallback<String>)((ValueCallback)s -> {}));
    }

    public void showWebPage(String url, boolean openExternal, boolean clearHistory, Map<String, Object> params) {
    }

    @Deprecated
    public boolean isCustomViewShowing() {
        return false;
    }

    @Deprecated
    public void showCustomView(View view, WebChromeClient.CustomViewCallback callback) {
    }

    @Deprecated
    public void hideCustomView() {
    }

    public CordovaResourceApi getResourceApi() {
        return this.resourceApi;
    }

    public void setButtonPlumbedToJs(int keyCode, boolean override) {
    }

    public boolean isButtonPlumbedToJs(int keyCode) {
        return false;
    }

    public void sendPluginResult(PluginResult cr, String callbackId) {
        this.nativeToJsMessageQueue.addPluginResult(cr, callbackId);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CordovaWebViewEngine getEngine() {
        return null;
    }

    public CordovaPreferences getPreferences() {
        return this.preferences;
    }

    public ICordovaCookieManager getCookieManager() {
        return this.cookieManager;
    }

    public String getUrl() {
        return this.webView.getUrl();
    }

    public Context getContext() {
        return this.webView.getContext();
    }

    public void loadUrl(String url) {
        this.loadUrlIntoView(url, true);
    }

    public Object postMessage(String id2, Object data) {
        return this.pluginManager.postMessage(id2, data);
    }

    public void setPaused(boolean value) {
        if (value) {
            this.webView.onPause();
            this.webView.pauseTimers();
        } else {
            this.webView.onResume();
            this.webView.resumeTimers();
        }
    }

    public static class CapacitorEvalBridgeMode
    extends NativeToJsMessageQueue.BridgeMode {
        private final WebView webView;
        private final CordovaInterface cordova;

        public CapacitorEvalBridgeMode(WebView webView, CordovaInterface cordova) {
            this.webView = webView;
            this.cordova = cordova;
        }

        public void onNativeToJsMessageAvailable(NativeToJsMessageQueue queue) {
            this.cordova.getActivity().runOnUiThread(() -> {
                String js = queue.popAndEncodeAsJs();
                if (js != null) {
                    this.webView.evaluateJavascript(js, null);
                }
            });
        }
    }
}

