/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor.plugin;

import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import com.getcapacitor.JSObject;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginConfig;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.plugin.CapacitorCookieManager;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

@CapacitorPlugin
public class CapacitorCookies
extends Plugin {
    CapacitorCookieManager cookieManager;

    @Override
    public void load() {
        this.bridge.getWebView().addJavascriptInterface((Object)this, "CapacitorCookiesAndroidInterface");
        this.cookieManager = new CapacitorCookieManager(null, CookiePolicy.ACCEPT_ALL, this.bridge);
        this.cookieManager.removeSessionCookies();
        CookieHandler.setDefault(this.cookieManager);
        super.load();
    }

    @Override
    protected void handleOnDestroy() {
        super.handleOnDestroy();
        this.cookieManager.removeSessionCookies();
    }

    @JavascriptInterface
    public boolean isEnabled() {
        PluginConfig pluginConfig = this.getBridge().getConfig().getPluginConfiguration("CapacitorCookies");
        return pluginConfig.getBoolean("enabled", false);
    }

    @JavascriptInterface
    public void setCookie(String domain, String action) {
        this.cookieManager.setCookie(domain, action);
    }

    @PluginMethod
    public void getCookies(PluginCall call) {
        this.bridge.eval("document.cookie", (ValueCallback<String>)((ValueCallback)value -> {
            String cookies = value.substring(1, value.length() - 1);
            String[] cookieArray = cookies.split(";");
            JSObject cookieMap = new JSObject();
            for (String cookie : cookieArray) {
                String[] keyValue;
                if (cookie.length() <= 0 || (keyValue = cookie.split("=", 2)).length != 2) continue;
                String key = keyValue[0].trim();
                String val = keyValue[1].trim();
                try {
                    key = URLDecoder.decode(keyValue[0].trim(), StandardCharsets.UTF_8.name());
                    val = URLDecoder.decode(keyValue[1].trim(), StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                cookieMap.put(key, val);
            }
            call.resolve(cookieMap);
        }));
    }

    @PluginMethod
    public void setCookie(PluginCall call) {
        String value;
        String key = call.getString("key");
        if (null == key) {
            call.reject("Must provide key");
        }
        if (null == (value = call.getString("value"))) {
            call.reject("Must provide value");
        }
        String url = call.getString("url");
        String expires = call.getString("expires", "");
        String path = call.getString("path", "/");
        this.cookieManager.setCookie(url, key, value, expires, path);
        call.resolve();
    }

    @PluginMethod
    public void deleteCookie(PluginCall call) {
        String key = call.getString("key");
        if (null == key) {
            call.reject("Must provide key");
        }
        String url = call.getString("url");
        this.cookieManager.setCookie(url, key + "=; Expires=Wed, 31 Dec 2000 23:59:59 GMT");
        call.resolve();
    }

    @PluginMethod
    public void clearCookies(PluginCall call) {
        HttpCookie[] cookies;
        String url = call.getString("url");
        for (HttpCookie cookie : cookies = this.cookieManager.getCookies(url)) {
            this.cookieManager.setCookie(url, cookie.getName() + "=; Expires=Wed, 31 Dec 2000 23:59:59 GMT");
        }
        call.resolve();
    }

    @PluginMethod
    public void clearAllCookies(PluginCall call) {
        this.cookieManager.removeAllCookies();
        call.resolve();
    }
}

