/*
 * Decompiled with CFR 0.152.
 */
package com.getcapacitor.plugin.util;

import android.text.TextUtils;
import android.util.Base64;
import com.getcapacitor.Bridge;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.JSValue;
import com.getcapacitor.PluginCall;
import com.getcapacitor.plugin.util.CapacitorHttpUrlConnection;
import com.getcapacitor.plugin.util.ICapacitorHttpUrlConnection;
import com.getcapacitor.plugin.util.MimeType;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpRequestHandler {
    public static JSObject buildResponse(CapacitorHttpUrlConnection connection) throws IOException, JSONException {
        return HttpRequestHandler.buildResponse(connection, ResponseType.DEFAULT);
    }

    public static JSObject buildResponse(CapacitorHttpUrlConnection connection, ResponseType responseType) throws IOException, JSONException {
        int statusCode = connection.getResponseCode();
        JSObject output = new JSObject();
        output.put("status", statusCode);
        output.put("headers", (Object)HttpRequestHandler.buildResponseHeaders(connection));
        output.put("url", connection.getURL());
        output.put("data", HttpRequestHandler.readData(connection, responseType));
        InputStream errorStream = connection.getErrorStream();
        if (errorStream != null) {
            output.put("error", true);
        }
        return output;
    }

    public static Object readData(ICapacitorHttpUrlConnection connection, ResponseType responseType) throws IOException, JSONException {
        InputStream errorStream = connection.getErrorStream();
        String contentType = connection.getHeaderField("Content-Type");
        if (errorStream != null) {
            if (HttpRequestHandler.isOneOf(contentType, MimeType.APPLICATION_JSON, MimeType.APPLICATION_VND_API_JSON)) {
                return HttpRequestHandler.parseJSON(HttpRequestHandler.readStreamAsString(errorStream));
            }
            return HttpRequestHandler.readStreamAsString(errorStream);
        }
        if (contentType != null && contentType.contains(MimeType.APPLICATION_JSON.getValue())) {
            return HttpRequestHandler.parseJSON(HttpRequestHandler.readStreamAsString(connection.getInputStream()));
        }
        InputStream stream = connection.getInputStream();
        switch (responseType) {
            case ARRAY_BUFFER: 
            case BLOB: {
                return HttpRequestHandler.readStreamAsBase64(stream);
            }
            case JSON: {
                return HttpRequestHandler.parseJSON(HttpRequestHandler.readStreamAsString(stream));
            }
        }
        return HttpRequestHandler.readStreamAsString(stream);
    }

    public static boolean isOneOf(String contentType, MimeType ... mimeTypes) {
        if (contentType != null) {
            for (MimeType mimeType : mimeTypes) {
                if (!contentType.contains(mimeType.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static JSObject buildResponseHeaders(CapacitorHttpUrlConnection connection) {
        JSObject output = new JSObject();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            String valuesString = TextUtils.join((CharSequence)", ", (Iterable)entry.getValue());
            output.put(entry.getKey(), valuesString);
        }
        return output;
    }

    /*
     * Loose catch block
     */
    public static Object parseJSON(String input) throws JSONException {
        block11: {
            JSONObject json = new JSONObject();
            if ("null".equals(input.trim())) {
                return JSONObject.NULL;
            }
            if ("true".equals(input.trim())) {
                return true;
            }
            if ("false".equals(input.trim())) {
                return false;
            }
            if (input.trim().length() <= 0) {
                return "";
            }
            if (input.trim().matches("^\".*\"$")) {
                return input.trim().substring(1, input.trim().length() - 1);
            }
            if (input.trim().matches("^-?\\d+$")) {
                return Integer.parseInt(input.trim());
            }
            if (!input.trim().matches("^-?\\d+(\\.\\d+)?$")) break block11;
            return Double.parseDouble(input.trim());
            {
                catch (JSONException e) {
                    return input;
                }
            }
        }
        try {
            return new JSObject(input);
        }
        catch (JSONException e) {
            return new JSArray(input);
        }
    }

    public static String readStreamAsBase64(InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int readBytes;
            byte[] buffer = new byte[1024];
            while ((readBytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, readBytes);
            }
            byte[] result = out.toByteArray();
            String string = Base64.encodeToString((byte[])result, (int)0, (int)result.length, (int)0);
            return string;
        }
    }

    public static String readStreamAsString(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                line = reader.readLine();
                if (line == null) continue;
                builder.append(System.getProperty("line.separator"));
            }
            String string = builder.toString();
            return string;
        }
    }

    public static JSObject request(PluginCall call, String httpMethod, Bridge bridge) throws IOException, URISyntaxException, JSONException {
        JSValue data;
        String urlString = call.getString("url", "");
        JSObject headers = call.getObject("headers", new JSObject());
        JSObject params = call.getObject("params", new JSObject());
        Integer connectTimeout = call.getInt("connectTimeout");
        Integer readTimeout = call.getInt("readTimeout");
        Boolean disableRedirects = call.getBoolean("disableRedirects");
        Boolean shouldEncode = call.getBoolean("shouldEncodeUrlParams", true);
        ResponseType responseType = ResponseType.parse(call.getString("responseType"));
        String dataType = call.getString("dataType");
        String method = httpMethod != null ? httpMethod.toUpperCase(Locale.ROOT) : call.getString("method", "GET").toUpperCase(Locale.ROOT);
        boolean isHttpMutate = method.equals("DELETE") || method.equals("PATCH") || method.equals("POST") || method.equals("PUT");
        URL url = new URL(urlString);
        HttpURLConnectionBuilder connectionBuilder = new HttpURLConnectionBuilder().setUrl(url).setMethod(method).setHeaders(headers).setUrlParams(params, shouldEncode).setConnectTimeout(connectTimeout).setReadTimeout(readTimeout).setDisableRedirects(disableRedirects).openConnection();
        CapacitorHttpUrlConnection connection = connectionBuilder.build();
        if (null != bridge && !HttpRequestHandler.isDomainExcludedFromSSL(bridge, url).booleanValue()) {
            connection.setSSLSocketFactory(bridge);
        }
        if (isHttpMutate && (data = new JSValue(call, "data")).getValue() != null) {
            connection.setDoOutput(true);
            connection.setRequestBody(call, data, dataType);
        }
        call.getData().put("activeCapacitorHttpUrlConnection", connection);
        connection.connect();
        JSObject response = HttpRequestHandler.buildResponse(connection, responseType);
        connection.disconnect();
        call.getData().remove("activeCapacitorHttpUrlConnection");
        return response;
    }

    public static Boolean isDomainExcludedFromSSL(Bridge bridge, URL url) {
        try {
            Class<?> sslPinningImpl = Class.forName("io.ionic.sslpinning.SSLPinning");
            Method method = sslPinningImpl.getDeclaredMethod("isDomainExcluded", Bridge.class, URL.class);
            return (Boolean)method.invoke(sslPinningImpl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), bridge, url);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static enum ResponseType {
        ARRAY_BUFFER("arraybuffer"),
        BLOB("blob"),
        DOCUMENT("document"),
        JSON("json"),
        TEXT("text");

        private final String name;
        static final ResponseType DEFAULT;

        private ResponseType(String name) {
            this.name = name;
        }

        public static ResponseType parse(String value) {
            for (ResponseType responseType : ResponseType.values()) {
                if (!responseType.name.equalsIgnoreCase(value)) continue;
                return responseType;
            }
            return DEFAULT;
        }

        static {
            DEFAULT = TEXT;
        }
    }

    public static class HttpURLConnectionBuilder {
        public Integer connectTimeout;
        public Integer readTimeout;
        public Boolean disableRedirects;
        public JSObject headers;
        public String method;
        public URL url;
        public CapacitorHttpUrlConnection connection;

        public HttpURLConnectionBuilder setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public HttpURLConnectionBuilder setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public HttpURLConnectionBuilder setDisableRedirects(Boolean disableRedirects) {
            this.disableRedirects = disableRedirects;
            return this;
        }

        public HttpURLConnectionBuilder setHeaders(JSObject headers) {
            this.headers = headers;
            return this;
        }

        public HttpURLConnectionBuilder setMethod(String method) {
            this.method = method;
            return this;
        }

        public HttpURLConnectionBuilder setUrl(URL url) {
            this.url = url;
            return this;
        }

        public HttpURLConnectionBuilder openConnection() throws IOException {
            this.connection = new CapacitorHttpUrlConnection((HttpURLConnection)this.url.openConnection());
            this.connection.setAllowUserInteraction(false);
            this.connection.setRequestMethod(this.method);
            if (this.connectTimeout != null) {
                this.connection.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout != null) {
                this.connection.setReadTimeout(this.readTimeout);
            }
            if (this.disableRedirects != null) {
                this.connection.setDisableRedirects(this.disableRedirects);
            }
            this.connection.setRequestHeaders(this.headers);
            return this;
        }

        public HttpURLConnectionBuilder setUrlParams(JSObject params) throws MalformedURLException, URISyntaxException, JSONException {
            return this.setUrlParams(params, true);
        }

        public HttpURLConnectionBuilder setUrlParams(JSObject params, boolean shouldEncode) throws URISyntaxException, MalformedURLException {
            String initialQuery = this.url.getQuery();
            String initialQueryBuilderStr = initialQuery == null ? "" : initialQuery;
            Iterator keys = params.keys();
            if (!keys.hasNext()) {
                return this;
            }
            StringBuilder urlQueryBuilder = new StringBuilder(initialQueryBuilderStr);
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    StringBuilder value = new StringBuilder();
                    JSONArray arr = params.getJSONArray(key);
                    for (int x = 0; x < arr.length(); ++x) {
                        HttpURLConnectionBuilder.addUrlParam(value, key, arr.getString(x), shouldEncode);
                        if (x == arr.length() - 1) continue;
                        value.append("&");
                    }
                    if (urlQueryBuilder.length() > 0) {
                        urlQueryBuilder.append("&");
                    }
                    urlQueryBuilder.append((CharSequence)value);
                }
                catch (JSONException e) {
                    if (urlQueryBuilder.length() > 0) {
                        urlQueryBuilder.append("&");
                    }
                    HttpURLConnectionBuilder.addUrlParam(urlQueryBuilder, key, params.getString(key), shouldEncode);
                }
            }
            String urlQuery = urlQueryBuilder.toString();
            URI uri = this.url.toURI();
            String unEncodedUrlString = uri.getScheme() + "://" + uri.getAuthority() + uri.getPath() + (!urlQuery.equals("") ? "?" + urlQuery : "") + (uri.getFragment() != null ? uri.getFragment() : "");
            this.url = new URL(unEncodedUrlString);
            return this;
        }

        private static void addUrlParam(StringBuilder sb, String key, String value, boolean shouldEncode) {
            if (shouldEncode) {
                try {
                    key = URLEncoder.encode(key, "UTF-8");
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex.getCause());
                }
            }
            sb.append(key).append("=").append(value);
        }

        public CapacitorHttpUrlConnection build() {
            return this.connection;
        }
    }

    @FunctionalInterface
    public static interface ProgressEmitter {
        public void emit(Integer var1, Integer var2);
    }
}

