/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.network;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import com.capacitorjs.plugins.network.NetworkStatus;

public class Network {
    @Nullable
    private NetworkStatusChangeListener statusChangeListener;
    private ConnectivityCallback connectivityCallback;
    private Context context;
    private ConnectivityManager connectivityManager;
    private BroadcastReceiver receiver;

    public Network(@NonNull Context context) {
        this.context = context;
        this.connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT <= 23) {
            this.receiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    Network.this.statusChangeListener.onNetworkStatusChanged(false);
                }
            };
        } else {
            this.connectivityCallback = new ConnectivityCallback();
        }
    }

    public void setStatusChangeListener(@Nullable NetworkStatusChangeListener listener) {
        this.statusChangeListener = listener;
    }

    @Nullable
    public NetworkStatusChangeListener getStatusChangeListener() {
        return this.statusChangeListener;
    }

    public NetworkStatus getNetworkStatus() {
        NetworkStatus networkStatus = new NetworkStatus();
        if (Build.VERSION.SDK_INT >= 24) {
            if (this.connectivityManager != null) {
                android.net.Network activeNetwork = this.connectivityManager.getActiveNetwork();
                NetworkCapabilities capabilities = this.connectivityManager.getNetworkCapabilities(this.connectivityManager.getActiveNetwork());
                if (activeNetwork != null && capabilities != null) {
                    boolean bl = networkStatus.connected = capabilities.hasCapability(16) && capabilities.hasCapability(12);
                    networkStatus.connectionType = capabilities.hasTransport(1) ? NetworkStatus.ConnectionType.WIFI : (capabilities.hasTransport(0) ? NetworkStatus.ConnectionType.CELLULAR : NetworkStatus.ConnectionType.UNKNOWN);
                }
            }
        } else {
            networkStatus = this.getAndParseNetworkInfo();
        }
        return networkStatus;
    }

    private NetworkStatus getAndParseNetworkInfo() {
        NetworkStatus networkStatus = new NetworkStatus();
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            networkStatus.connected = networkInfo.isConnected();
            String typeName = networkInfo.getTypeName();
            if (typeName.equals("WIFI")) {
                networkStatus.connectionType = NetworkStatus.ConnectionType.WIFI;
            } else if (typeName.equals("MOBILE")) {
                networkStatus.connectionType = NetworkStatus.ConnectionType.CELLULAR;
            }
        }
        return networkStatus;
    }

    @RequiresApi(api=24)
    public void startMonitoring() {
        this.connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.connectivityCallback);
    }

    @TargetApi(value=23)
    public void startMonitoring(AppCompatActivity activity) {
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        activity.registerReceiver(this.receiver, filter);
    }

    @RequiresApi(api=24)
    public void stopMonitoring() {
        this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.connectivityCallback);
    }

    @TargetApi(value=23)
    public void stopMonitoring(@NonNull AppCompatActivity activity) {
        activity.unregisterReceiver(this.receiver);
    }

    class ConnectivityCallback
    extends ConnectivityManager.NetworkCallback {
        ConnectivityCallback() {
        }

        public void onLost(@NonNull android.net.Network network) {
            super.onLost(network);
            Network.this.statusChangeListener.onNetworkStatusChanged(true);
        }

        public void onCapabilitiesChanged(@NonNull android.net.Network network, @NonNull NetworkCapabilities networkCapabilities) {
            super.onCapabilitiesChanged(network, networkCapabilities);
            Network.this.statusChangeListener.onNetworkStatusChanged(false);
        }
    }

    static interface NetworkStatusChangeListener {
        public void onNetworkStatusChanged(boolean var1);
    }
}

