/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.network;

import android.os.Build;
import android.util.Log;
import com.capacitorjs.plugins.network.Network;
import com.capacitorjs.plugins.network.NetworkStatus;
import com.getcapacitor.JSObject;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;

@CapacitorPlugin(name="Network")
public class NetworkPlugin
extends Plugin {
    private Network implementation;
    public static final String NETWORK_CHANGE_EVENT = "networkStatusChange";
    private NetworkStatus prePauseNetworkStatus = null;

    public void load() {
        this.implementation = new Network(this.getContext());
        Network.NetworkStatusChangeListener listener = wasLostEvent -> {
            if (wasLostEvent) {
                JSObject jsObject = new JSObject();
                jsObject.put("connected", false);
                jsObject.put("connectionType", "none");
                this.notifyListeners(NETWORK_CHANGE_EVENT, jsObject);
            } else {
                this.updateNetworkStatus();
            }
        };
        this.implementation.setStatusChangeListener(listener);
    }

    protected void handleOnDestroy() {
        this.implementation.setStatusChangeListener(null);
    }

    @PluginMethod
    public void getStatus(PluginCall call) {
        call.resolve(this.parseNetworkStatus(this.implementation.getNetworkStatus()));
    }

    protected void handleOnResume() {
        if (Build.VERSION.SDK_INT >= 24) {
            this.implementation.startMonitoring();
        } else {
            this.implementation.startMonitoring(this.getActivity());
        }
        NetworkStatus afterPauseNetworkStatus = this.implementation.getNetworkStatus();
        if (this.prePauseNetworkStatus != null && !afterPauseNetworkStatus.connected && (this.prePauseNetworkStatus.connected || afterPauseNetworkStatus.connectionType != this.prePauseNetworkStatus.connectionType)) {
            Log.d((String)"Capacitor/NetworkPlugin", (String)"Detected pre-pause and after-pause network status mismatch. Updating network status and notifying listeners.");
            this.updateNetworkStatus();
        }
        this.prePauseNetworkStatus = null;
    }

    protected void handleOnPause() {
        this.prePauseNetworkStatus = this.implementation.getNetworkStatus();
        if (Build.VERSION.SDK_INT >= 24) {
            this.implementation.stopMonitoring();
        } else {
            this.implementation.stopMonitoring(this.getActivity());
        }
    }

    private void updateNetworkStatus() {
        this.notifyListeners(NETWORK_CHANGE_EVENT, this.parseNetworkStatus(this.implementation.getNetworkStatus()));
    }

    private JSObject parseNetworkStatus(NetworkStatus networkStatus) {
        JSObject jsObject = new JSObject();
        jsObject.put("connected", networkStatus.connected);
        jsObject.put("connectionType", networkStatus.connectionType.getConnectionType());
        return jsObject;
    }
}

