/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import com.capacitorjs.plugins.preferences.PreferencesConfiguration;
import java.util.Set;

public class Preferences {
    private SharedPreferences preferences;

    Preferences(Context context, PreferencesConfiguration configuration) {
        this.preferences = context.getSharedPreferences(configuration.group, 0);
    }

    public String get(String key) {
        return this.preferences.getString(key, null);
    }

    public void set(String key, String value) {
        this.executeOperation(editor -> editor.putString(key, value));
    }

    public void remove(String key) {
        this.executeOperation(editor -> editor.remove(key));
    }

    public Set<String> keys() {
        return this.preferences.getAll().keySet();
    }

    public void clear() {
        this.executeOperation(SharedPreferences.Editor::clear);
    }

    private void executeOperation(PreferencesOperation op) {
        SharedPreferences.Editor editor = this.preferences.edit();
        op.execute(editor);
        editor.apply();
    }

    private static interface PreferencesOperation {
        public void execute(SharedPreferences.Editor var1);
    }
}

