/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.preferences;

import com.capacitorjs.plugins.preferences.Preferences;
import com.capacitorjs.plugins.preferences.PreferencesConfiguration;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONException;

@CapacitorPlugin(name="Preferences")
public class PreferencesPlugin
extends Plugin {
    private Preferences preferences;

    public void load() {
        this.preferences = new Preferences(this.getContext(), PreferencesConfiguration.DEFAULTS);
    }

    @PluginMethod
    public void configure(PluginCall call) {
        try {
            PreferencesConfiguration configuration = PreferencesConfiguration.DEFAULTS.clone();
            configuration.group = call.getString("group", PreferencesConfiguration.DEFAULTS.group);
            this.preferences = new Preferences(this.getContext(), configuration);
        }
        catch (CloneNotSupportedException e) {
            call.reject("Error while configuring", (Exception)e);
            return;
        }
        call.resolve();
    }

    @PluginMethod
    public void get(PluginCall call) {
        String key = call.getString("key");
        if (key == null) {
            call.reject("Must provide key");
            return;
        }
        String value = this.preferences.get(key);
        JSObject ret = new JSObject();
        ret.put("value", value == null ? JSObject.NULL : value);
        call.resolve(ret);
    }

    @PluginMethod
    public void set(PluginCall call) {
        String key = call.getString("key");
        if (key == null) {
            call.reject("Must provide key");
            return;
        }
        String value = call.getString("value");
        this.preferences.set(key, value);
        call.resolve();
    }

    @PluginMethod
    public void remove(PluginCall call) {
        String key = call.getString("key");
        if (key == null) {
            call.reject("Must provide key");
            return;
        }
        this.preferences.remove(key);
        call.resolve();
    }

    @PluginMethod
    public void keys(PluginCall call) {
        Set<String> keySet = this.preferences.keys();
        String[] keys = keySet.toArray(new String[0]);
        JSObject ret = new JSObject();
        try {
            ret.put("keys", (Object)new JSArray((Object)keys));
        }
        catch (JSONException ex) {
            call.reject("Unable to serialize response.", (Exception)((Object)ex));
            return;
        }
        call.resolve(ret);
    }

    @PluginMethod
    public void clear(PluginCall call) {
        this.preferences.clear();
        call.resolve();
    }

    @PluginMethod
    public void migrate(PluginCall call) {
        ArrayList<String> migrated = new ArrayList<String>();
        ArrayList<String> existing = new ArrayList<String>();
        Preferences oldPreferences = new Preferences(this.getContext(), PreferencesConfiguration.DEFAULTS);
        for (String key : oldPreferences.keys()) {
            String value = oldPreferences.get(key);
            String currentValue = this.preferences.get(key);
            if (currentValue == null) {
                this.preferences.set(key, value);
                migrated.add(key);
                continue;
            }
            existing.add(key);
        }
        JSObject ret = new JSObject();
        ret.put("migrated", (Object)new JSArray(migrated));
        ret.put("existing", (Object)new JSArray(existing));
        call.resolve(ret);
    }

    @PluginMethod
    public void removeOld(PluginCall call) {
        call.resolve();
    }
}

