/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.splashscreen;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Handler;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import com.capacitorjs.plugins.splashscreen.R;
import com.capacitorjs.plugins.splashscreen.SplashListener;
import com.capacitorjs.plugins.splashscreen.SplashScreenConfig;
import com.capacitorjs.plugins.splashscreen.SplashScreenSettings;
import com.getcapacitor.Logger;

public class SplashScreen {
    private Dialog dialog;
    private View splashImage;
    private ProgressBar spinnerBar;
    private WindowManager windowManager;
    private boolean isVisible = false;
    private boolean isHiding = false;
    private Context context;
    private View content;
    private SplashScreenConfig config;
    private ViewTreeObserver.OnPreDrawListener onPreDrawListener;

    SplashScreen(Context context, SplashScreenConfig config) {
        this.context = context;
        this.config = config;
    }

    public void showOnLaunch(AppCompatActivity activity) {
        if (this.config.getLaunchShowDuration() == 0) {
            return;
        }
        SplashScreenSettings settings = new SplashScreenSettings();
        settings.setShowDuration(this.config.getLaunchShowDuration());
        settings.setAutoHide(this.config.isLaunchAutoHide());
        try {
            this.showWithAndroid12API(activity, settings);
            return;
        }
        catch (Exception e) {
            Logger.warn((String)"Android 12 Splash API failed... using previous method.");
            this.onPreDrawListener = null;
            settings.setFadeInDuration(this.config.getLaunchFadeInDuration());
            if (this.config.isUsingDialog()) {
                this.showDialog(activity, settings, null, true);
            } else {
                this.show(activity, settings, null, true);
            }
            return;
        }
    }

    private void showWithAndroid12API(AppCompatActivity activity, final SplashScreenSettings settings) {
        if (activity == null || activity.isFinishing()) {
            return;
        }
        activity.runOnUiThread(() -> {
            androidx.core.splashscreen.SplashScreen windowSplashScreen = androidx.core.splashscreen.SplashScreen.installSplashScreen((Activity)activity);
            windowSplashScreen.setKeepOnScreenCondition(() -> this.isVisible || this.isHiding);
            if (this.config.getLaunchFadeOutDuration() > 0) {
                windowSplashScreen.setOnExitAnimationListener(windowSplashScreenView -> {
                    ObjectAnimator fadeAnimator = ObjectAnimator.ofFloat((Object)windowSplashScreenView.getView(), (Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f});
                    fadeAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                    fadeAnimator.setDuration((long)this.config.getLaunchFadeOutDuration().intValue());
                    fadeAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SplashScreen.this.isHiding = false;
                            windowSplashScreenView.remove();
                        }
                    });
                    fadeAnimator.start();
                    this.isHiding = true;
                    this.isVisible = false;
                });
            }
            this.content = activity.findViewById(0x1020002);
            this.onPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    if (!SplashScreen.this.isVisible && !SplashScreen.this.isHiding) {
                        SplashScreen.this.isVisible = true;
                        new Handler(SplashScreen.this.context.getMainLooper()).postDelayed(() -> {
                            if (settings.isAutoHide()) {
                                SplashScreen.this.isVisible = false;
                                SplashScreen.this.onPreDrawListener = null;
                                SplashScreen.this.content.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                            }
                        }, (long)settings.getShowDuration().intValue());
                    }
                    return false;
                }
            };
            this.content.getViewTreeObserver().addOnPreDrawListener(this.onPreDrawListener);
        });
    }

    public void show(AppCompatActivity activity, SplashScreenSettings settings, SplashListener splashListener) {
        if (this.config.isUsingDialog()) {
            this.showDialog(activity, settings, splashListener, false);
        } else {
            this.show(activity, settings, splashListener, false);
        }
    }

    private void showDialog(AppCompatActivity activity, SplashScreenSettings settings, SplashListener splashListener, boolean isLaunchSplash) {
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (this.isVisible) {
            splashListener.completed();
            return;
        }
        activity.runOnUiThread(() -> {
            this.dialog = this.config.isImmersive() ? new Dialog((Context)activity, R.style.capacitor_immersive_style) : (this.config.isFullScreen() ? new Dialog((Context)activity, R.style.capacitor_full_screen_style) : new Dialog((Context)activity, R.style.capacitor_default_style));
            int splashId = 0;
            if (this.config.getLayoutName() != null && (splashId = this.context.getResources().getIdentifier(this.config.getLayoutName(), "layout", this.context.getPackageName())) == 0) {
                Logger.warn((String)"Layout not found, using default");
            }
            if (splashId != 0) {
                this.dialog.setContentView(splashId);
            } else {
                Drawable splash = this.getSplashDrawable();
                LinearLayout parent = new LinearLayout(this.context);
                parent.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                parent.setOrientation(1);
                if (splash != null) {
                    parent.setBackground(splash);
                }
                this.dialog.setContentView((View)parent);
            }
            this.dialog.setCancelable(false);
            if (!this.dialog.isShowing()) {
                this.dialog.show();
            }
            this.isVisible = true;
            if (settings.isAutoHide()) {
                new Handler(this.context.getMainLooper()).postDelayed(() -> {
                    this.hideDialog(activity, isLaunchSplash);
                    if (splashListener != null) {
                        splashListener.completed();
                    }
                }, (long)settings.getShowDuration().intValue());
            } else if (splashListener != null) {
                splashListener.completed();
            }
        });
    }

    public void hide(SplashScreenSettings settings) {
        this.hide(settings.getFadeOutDuration(), false);
    }

    public void hideDialog(AppCompatActivity activity) {
        this.hideDialog(activity, false);
    }

    public void onPause() {
        this.tearDown(true);
    }

    public void onDestroy() {
        this.tearDown(true);
    }

    private void buildViews() {
        if (this.splashImage == null) {
            int splashId = 0;
            if (this.config.getLayoutName() != null && (splashId = this.context.getResources().getIdentifier(this.config.getLayoutName(), "layout", this.context.getPackageName())) == 0) {
                Logger.warn((String)"Layout not found, defaulting to ImageView");
            }
            if (splashId != 0) {
                Activity activity = (Activity)this.context;
                LayoutInflater inflator = activity.getLayoutInflater();
                FrameLayout root = new FrameLayout(this.context);
                root.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.splashImage = inflator.inflate(splashId, (ViewGroup)root, false);
            } else {
                Drawable splash = this.getSplashDrawable();
                if (splash != null) {
                    if (splash instanceof Animatable) {
                        ((Animatable)splash).start();
                    }
                    if (splash instanceof LayerDrawable) {
                        LayerDrawable layeredSplash = (LayerDrawable)splash;
                        for (int i = 0; i < layeredSplash.getNumberOfLayers(); ++i) {
                            Drawable layerDrawable = layeredSplash.getDrawable(i);
                            if (!(layerDrawable instanceof Animatable)) continue;
                            ((Animatable)layerDrawable).start();
                        }
                    }
                    this.splashImage = new ImageView(this.context);
                    ImageView imageView = (ImageView)this.splashImage;
                    if (Build.VERSION.SDK_INT >= 28) {
                        imageView.setLayerType(1, null);
                    } else {
                        this.legacyStopFlickers(imageView);
                    }
                    imageView.setScaleType(this.config.getScaleType());
                    imageView.setImageDrawable(splash);
                } else {
                    return;
                }
            }
            this.splashImage.setFitsSystemWindows(true);
            if (this.config.getBackgroundColor() != null) {
                this.splashImage.setBackgroundColor(this.config.getBackgroundColor().intValue());
            }
        }
        if (this.spinnerBar == null) {
            if (this.config.getSpinnerStyle() != null) {
                int spinnerBarStyle = this.config.getSpinnerStyle();
                this.spinnerBar = new ProgressBar(this.context, null, spinnerBarStyle);
            } else {
                this.spinnerBar = new ProgressBar(this.context);
            }
            this.spinnerBar.setIndeterminate(true);
            Integer spinnerBarColor = this.config.getSpinnerColor();
            if (spinnerBarColor != null) {
                int[][] states = new int[][]{{16842910}, {-16842910}, {-16842912}, {16842919}};
                int[] colors = new int[]{spinnerBarColor, spinnerBarColor, spinnerBarColor, spinnerBarColor};
                ColorStateList colorStateList = new ColorStateList((int[][])states, colors);
                this.spinnerBar.setIndeterminateTintList(colorStateList);
            }
        }
    }

    private void legacyStopFlickers(ImageView imageView) {
        imageView.setDrawingCacheEnabled(true);
    }

    private Drawable getSplashDrawable() {
        int splashId = this.context.getResources().getIdentifier(this.config.getResourceName(), "drawable", this.context.getPackageName());
        try {
            Drawable drawable = this.context.getResources().getDrawable(splashId, this.context.getTheme());
            return drawable;
        }
        catch (Resources.NotFoundException ex) {
            Logger.warn((String)"No splash screen found, not displaying");
            return null;
        }
    }

    private void show(AppCompatActivity activity, final SplashScreenSettings settings, final SplashListener splashListener, final boolean isLaunchSplash) {
        this.windowManager = (WindowManager)activity.getSystemService("window");
        if (activity.isFinishing()) {
            return;
        }
        this.buildViews();
        if (this.isVisible) {
            splashListener.completed();
            return;
        }
        Animator.AnimatorListener listener = new Animator.AnimatorListener(){

            public void onAnimationEnd(Animator animator) {
                SplashScreen.this.isVisible = true;
                if (settings.isAutoHide()) {
                    new Handler(SplashScreen.this.context.getMainLooper()).postDelayed(() -> {
                        SplashScreen.this.hide(settings.getFadeOutDuration(), isLaunchSplash);
                        if (splashListener != null) {
                            splashListener.completed();
                        }
                    }, (long)settings.getShowDuration().intValue());
                } else if (splashListener != null) {
                    splashListener.completed();
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }

            public void onAnimationStart(Animator animator) {
            }
        };
        Handler mainHandler = new Handler(this.context.getMainLooper());
        mainHandler.post(() -> {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.gravity = 17;
            params.flags = activity.getWindow().getAttributes().flags;
            params.format = -3;
            try {
                this.windowManager.addView(this.splashImage, (ViewGroup.LayoutParams)params);
            }
            catch (IllegalArgumentException | IllegalStateException ex) {
                Logger.debug((String)"Could not add splash view");
                return;
            }
            if (this.config.isImmersive()) {
                if (Build.VERSION.SDK_INT >= 30) {
                    activity.runOnUiThread(() -> {
                        Window window = activity.getWindow();
                        WindowCompat.setDecorFitsSystemWindows((Window)window, (boolean)false);
                        WindowInsetsController controller = this.splashImage.getWindowInsetsController();
                        controller.hide(WindowInsetsCompat.Type.systemBars());
                        controller.setSystemBarsBehavior(2);
                    });
                } else {
                    this.legacyImmersive();
                }
            } else if (this.config.isFullScreen()) {
                if (Build.VERSION.SDK_INT >= 30) {
                    activity.runOnUiThread(() -> {
                        Window window = activity.getWindow();
                        WindowCompat.setDecorFitsSystemWindows((Window)window, (boolean)false);
                        WindowInsetsController controller = this.splashImage.getWindowInsetsController();
                        controller.hide(WindowInsetsCompat.Type.statusBars());
                    });
                } else {
                    this.legacyFullscreen();
                }
            }
            this.splashImage.setAlpha(0.0f);
            this.splashImage.animate().alpha(1.0f).setInterpolator((TimeInterpolator)new LinearInterpolator()).setDuration((long)settings.getFadeInDuration().intValue()).setListener(listener).start();
            this.splashImage.setVisibility(0);
            if (this.spinnerBar != null) {
                this.spinnerBar.setVisibility(4);
                if (this.spinnerBar.getParent() != null) {
                    this.windowManager.removeView((View)this.spinnerBar);
                }
                params.height = -2;
                params.width = -2;
                this.windowManager.addView((View)this.spinnerBar, (ViewGroup.LayoutParams)params);
                if (this.config.isShowSpinner()) {
                    this.spinnerBar.setAlpha(0.0f);
                    this.spinnerBar.animate().alpha(1.0f).setInterpolator((TimeInterpolator)new LinearInterpolator()).setDuration((long)settings.getFadeInDuration().intValue()).start();
                    this.spinnerBar.setVisibility(0);
                }
            }
        });
    }

    private void legacyImmersive() {
        int flags = 5894;
        this.splashImage.setSystemUiVisibility(5894);
    }

    private void legacyFullscreen() {
        this.splashImage.setSystemUiVisibility(4);
    }

    private void hide(int fadeOutDuration, boolean isLaunchSplash) {
        if (isLaunchSplash && this.isVisible) {
            Logger.debug((String)"SplashScreen was automatically hidden after the launch timeout. You should call `SplashScreen.hide()` as soon as your web app is loaded (or increase the timeout).Read more at https://capacitorjs.com/docs/apis/splash-screen#hiding-the-splash-screen");
        }
        if (this.isHiding) {
            return;
        }
        if (null != this.onPreDrawListener) {
            if (fadeOutDuration != 200) {
                Logger.warn((String)"fadeOutDuration parameter doesn't work on initial splash screen, use launchFadeOutDuration configuration option");
            }
            this.isVisible = false;
            if (null != this.content) {
                this.content.getViewTreeObserver().removeOnPreDrawListener(this.onPreDrawListener);
            }
            this.onPreDrawListener = null;
            return;
        }
        if (this.splashImage == null || this.splashImage.getParent() == null) {
            return;
        }
        this.isHiding = true;
        Animator.AnimatorListener listener = new Animator.AnimatorListener(){

            public void onAnimationEnd(Animator animator) {
                SplashScreen.this.tearDown(false);
            }

            public void onAnimationCancel(Animator animator) {
                SplashScreen.this.tearDown(false);
            }

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        };
        Handler mainHandler = new Handler(this.context.getMainLooper());
        mainHandler.post(() -> {
            if (this.spinnerBar != null) {
                this.spinnerBar.setAlpha(1.0f);
                this.spinnerBar.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new LinearInterpolator()).setDuration((long)fadeOutDuration).start();
            }
            this.splashImage.setAlpha(1.0f);
            this.splashImage.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new LinearInterpolator()).setDuration((long)fadeOutDuration).setListener(listener).start();
        });
    }

    private void hideDialog(AppCompatActivity activity, boolean isLaunchSplash) {
        if (isLaunchSplash && this.isVisible) {
            Logger.debug((String)"SplashScreen was automatically hidden after the launch timeout. You should call `SplashScreen.hide()` as soon as your web app is loaded (or increase the timeout).Read more at https://capacitorjs.com/docs/apis/splash-screen#hiding-the-splash-screen");
        }
        if (this.isHiding) {
            return;
        }
        if (null != this.onPreDrawListener) {
            this.isVisible = false;
            if (null != this.content) {
                this.content.getViewTreeObserver().removeOnPreDrawListener(this.onPreDrawListener);
            }
            this.onPreDrawListener = null;
            return;
        }
        this.isHiding = true;
        activity.runOnUiThread(() -> {
            if (this.dialog != null && this.dialog.isShowing()) {
                if (!activity.isFinishing() && !activity.isDestroyed()) {
                    this.dialog.dismiss();
                }
                this.dialog = null;
                this.isHiding = false;
                this.isVisible = false;
            }
        });
    }

    private void tearDown(boolean removeSpinner) {
        if (this.spinnerBar != null && this.spinnerBar.getParent() != null) {
            this.spinnerBar.setVisibility(4);
            if (removeSpinner) {
                this.windowManager.removeView((View)this.spinnerBar);
            }
        }
        if (this.splashImage != null && this.splashImage.getParent() != null) {
            this.splashImage.setVisibility(4);
            this.windowManager.removeView(this.splashImage);
        }
        if (Build.VERSION.SDK_INT >= 30 && this.config.isFullScreen() || this.config.isImmersive()) {
            Window window = ((Activity)this.context).getWindow();
            WindowCompat.setDecorFitsSystemWindows((Window)window, (boolean)true);
        }
        this.isHiding = false;
        this.isVisible = false;
    }
}

