/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.splashscreen;

import android.widget.ImageView;
import com.capacitorjs.plugins.splashscreen.SplashListener;
import com.capacitorjs.plugins.splashscreen.SplashScreen;
import com.capacitorjs.plugins.splashscreen.SplashScreenConfig;
import com.capacitorjs.plugins.splashscreen.SplashScreenSettings;
import com.getcapacitor.Logger;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.util.WebColor;
import java.util.Locale;

@CapacitorPlugin(name="SplashScreen")
public class SplashScreenPlugin
extends Plugin {
    private SplashScreen splashScreen;
    private SplashScreenConfig config;

    public void load() {
        this.config = this.getSplashScreenConfig();
        this.splashScreen = new SplashScreen(this.getContext(), this.config);
        if (!this.bridge.isMinimumWebViewInstalled() && this.bridge.getConfig().getErrorPath() != null && !this.config.isLaunchAutoHide()) {
            return;
        }
        this.splashScreen.showOnLaunch(this.getActivity());
    }

    @PluginMethod
    public void show(final PluginCall call) {
        this.splashScreen.show(this.getActivity(), this.getSettings(call), new SplashListener(){

            @Override
            public void completed() {
                call.resolve();
            }

            @Override
            public void error() {
                call.reject("An error occurred while showing splash");
            }
        });
    }

    @PluginMethod
    public void hide(PluginCall call) {
        if (this.config.isUsingDialog()) {
            this.splashScreen.hideDialog(this.getActivity());
        } else {
            this.splashScreen.hide(this.getSettings(call));
        }
        call.resolve();
    }

    protected void handleOnPause() {
        this.splashScreen.onPause();
    }

    protected void handleOnDestroy() {
        this.splashScreen.onDestroy();
    }

    private SplashScreenSettings getSettings(PluginCall call) {
        SplashScreenSettings settings = new SplashScreenSettings();
        if (call.getInt("showDuration") != null) {
            settings.setShowDuration(call.getInt("showDuration"));
        }
        if (call.getInt("fadeInDuration") != null) {
            settings.setFadeInDuration(call.getInt("fadeInDuration"));
        }
        if (call.getInt("fadeOutDuration") != null) {
            settings.setFadeOutDuration(call.getInt("fadeOutDuration"));
        }
        if (call.getBoolean("autoHide") != null) {
            settings.setAutoHide(call.getBoolean("autoHide"));
        }
        return settings;
    }

    private SplashScreenConfig getSplashScreenConfig() {
        String scaleTypeName;
        String spinnerColor;
        SplashScreenConfig config = new SplashScreenConfig();
        String backgroundColor = this.getConfig().getString("backgroundColor");
        if (backgroundColor != null) {
            try {
                config.setBackgroundColor(WebColor.parseColor((String)backgroundColor));
            }
            catch (IllegalArgumentException ex) {
                Logger.debug((String)"Background color not applied");
            }
        }
        Integer duration = this.getConfig().getInt("launchShowDuration", config.getLaunchShowDuration().intValue());
        config.setLaunchShowDuration(duration);
        Integer fadeOutDuration = this.getConfig().getInt("launchFadeOutDuration", config.getLaunchFadeOutDuration().intValue());
        config.setLaunchFadeOutDuration(fadeOutDuration);
        Boolean autohide = this.getConfig().getBoolean("launchAutoHide", config.isLaunchAutoHide());
        config.setLaunchAutoHide(autohide);
        if (this.getConfig().getString("androidSplashResourceName") != null) {
            config.setResourceName(this.getConfig().getString("androidSplashResourceName"));
        }
        Boolean immersive = this.getConfig().getBoolean("splashImmersive", config.isImmersive());
        config.setImmersive(immersive);
        Boolean fullScreen = this.getConfig().getBoolean("splashFullScreen", config.isFullScreen());
        config.setFullScreen(fullScreen);
        String spinnerStyle = this.getConfig().getString("androidSpinnerStyle");
        if (spinnerStyle != null) {
            int spinnerBarStyle = 16842874;
            switch (spinnerStyle.toLowerCase(Locale.ROOT)) {
                case "horizontal": {
                    spinnerBarStyle = 16842872;
                    break;
                }
                case "small": {
                    spinnerBarStyle = 16842873;
                    break;
                }
                case "large": {
                    spinnerBarStyle = 16842874;
                    break;
                }
                case "inverse": {
                    spinnerBarStyle = 16843399;
                    break;
                }
                case "smallinverse": {
                    spinnerBarStyle = 16843400;
                    break;
                }
                case "largeinverse": {
                    spinnerBarStyle = 16843401;
                }
            }
            config.setSpinnerStyle(spinnerBarStyle);
        }
        if ((spinnerColor = this.getConfig().getString("spinnerColor")) != null) {
            try {
                config.setSpinnerColor(WebColor.parseColor((String)spinnerColor));
            }
            catch (IllegalArgumentException ex) {
                Logger.debug((String)"Spinner color not applied");
            }
        }
        if ((scaleTypeName = this.getConfig().getString("androidScaleType")) != null) {
            ImageView.ScaleType scaleType = null;
            try {
                scaleType = ImageView.ScaleType.valueOf((String)scaleTypeName);
            }
            catch (IllegalArgumentException ex) {
                scaleType = ImageView.ScaleType.FIT_XY;
            }
            config.setScaleType(scaleType);
        }
        Boolean showSpinner = this.getConfig().getBoolean("showSpinner", config.isShowSpinner());
        config.setShowSpinner(showSpinner);
        Boolean useDialog = this.getConfig().getBoolean("useDialog", config.isUsingDialog());
        config.setUsingDialog(useDialog);
        if (this.getConfig().getString("layoutName") != null) {
            config.setLayoutName(this.getConfig().getString("layoutName"));
        }
        return config;
    }
}

